/*
 * Decompiled with CFR 0.152.
 */
package org.everit.authnr.qdsl.util.ri;

import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Objects;
import org.everit.authentication.context.AuthenticationContext;
import org.everit.authnr.qdsl.util.AuthnrQdslUtil;
import org.everit.authorization.qdsl.util.AuthorizationQdslUtil;

public class AuthnrQdslUtilImpl
implements AuthnrQdslUtil {
    private final AuthenticationContext authenticationContext;
    private final AuthorizationQdslUtil authorizationQdslUtil;

    public AuthnrQdslUtilImpl(AuthenticationContext authenticationContext, AuthorizationQdslUtil authorizationQdslUtil) {
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext cannot be null");
        this.authorizationQdslUtil = Objects.requireNonNull(authorizationQdslUtil, "authorizationQdslUtil cannot be null");
    }

    public BooleanExpression authorizationPredicate(Expression<Long> targetResourceId, String ... actions) {
        long authorizedResourceId = this.authenticationContext.getCurrentResourceId();
        return this.authorizationQdslUtil.authorizationPredicate(authorizedResourceId, targetResourceId, actions);
    }
}

