/*
 * Decompiled with CFR 0.152.
 */
package org.everit.cache.lru.ecm.internal;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.everit.cache.CacheConstants;
import org.everit.cache.lru.ecm.LruCacheConstants;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.attribute.LongAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.cache.lru.ecm.LruCache", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit LRU Cache", description="LRU in-memory cache component based on a high performance ConcurrentLinkedHashMap.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Default LRU cache"}, priority=1.0f, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualServices(value={@ManualService(value={Map.class, ConcurrentMap.class, ConcurrentLinkedHashMap.class})})
@ExtendComponent
public class LruCacheComponent<K, V> {
    public static final int P01_SERVICE_DESCRIPTION = 1;
    public static final int P02_CAPACITY = 2;
    private long capacity;
    private ServiceRegistration<?> serviceRegistration;

    @Activate
    public void activate(ComponentContext<LruCacheComponent<K, V>> componentContext) {
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        ConcurrentLinkedHashMap cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.capacity).build();
        this.serviceRegistration = componentContext.registerService(new String[]{LruCacheConstants.OBJECT_CLASS_CONCURRENT_LINKED_HASH_MAP.getName(), LruCacheConstants.OBJECT_CLASS_CONCURRENT_MAP.getName(), CacheConstants.OBJECT_CLASS_MAP.getName()}, (Object)cache, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @LongAttribute(attributeId="capacity", defaultValue={1000L}, priority=2.0f, label="Capacity", description="The maximum number of elements stored in the cache.")
    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }
}

