/*
 * Decompiled with CFR 0.152.
 */
package org.everit.commons.selection;

import java.io.Serializable;

public class Limit
implements Serializable {
    private static final long serialVersionUID = 3535393755786439877L;
    public static final long FIRST_RESULT_MIN_VALUE = 0L;
    public static final long MAX_RESULTS_MIN_VALUE = 1L;
    private final long firstResult;
    private final long maxResults;

    public Limit(long firstResult, long maxResults) {
        if (firstResult < 0L) {
            throw new IllegalArgumentException("firstResult [" + firstResult + "] is less than FIRST_RESULT_MIN_VALUE [" + 0L + "]");
        }
        if (maxResults < 1L) {
            throw new IllegalArgumentException("maxResults [" + maxResults + "] is less than MAX_RESULTS_MIN_VALUE [" + 1L + "]");
        }
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Limit other = (Limit)obj;
        if (this.firstResult != other.firstResult) {
            return false;
        }
        return this.maxResults == other.maxResults;
    }

    public long getFirstResult() {
        return this.firstResult;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstResult ^ this.firstResult >>> 32);
        result = 31 * result + (int)(this.maxResults ^ this.maxResults >>> 32);
        return result;
    }

    public String toString() {
        return "Limit [firstResult=" + this.firstResult + ", maxResults=" + this.maxResults + "]";
    }
}

