/*
 * Decompiled with CFR 0.152.
 */
package org.everit.commons.selection;

import org.everit.commons.selection.Limit;

public final class LimitUtil {
    public static Limit shiftIfNecessary(Limit limit, long numberOfAllElements) {
        if (limit == null) {
            throw new NullPointerException("limit cannot be null");
        }
        if (numberOfAllElements < 0L) {
            throw new IllegalArgumentException("numberOfAllElements [" + numberOfAllElements + "] is less than NUMBER_OF_ALL_ELEMENTS_MIN_VALUE [" + 0L + "]");
        }
        long maxResults = limit.getMaxResults();
        if (numberOfAllElements == 0L) {
            return new Limit(0L, maxResults);
        }
        long firstResult = limit.getFirstResult();
        if (firstResult < numberOfAllElements) {
            return limit;
        }
        long newFirstResult = numberOfAllElements / maxResults * maxResults;
        if (newFirstResult == numberOfAllElements) {
            newFirstResult -= maxResults;
        }
        return new Limit(newFirstResult, maxResults);
    }

    private LimitUtil() {
    }
}

