/*
 * Decompiled with CFR 0.152.
 */
package org.everit.commons.selection;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.everit.commons.selection.Limit;

public class LimitedResult<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 6257187399825248108L;
    public static final long NUMBER_OF_ALL_ELEMENTS_MIN_VALUE = 0L;
    private final List<T> elements;
    private final long numberOfAllElements;
    private final Limit limit;

    public LimitedResult(List<T> elements, long numberOfAllElements, Limit limit) {
        if (elements == null) {
            throw new NullPointerException("elements cannot be null");
        }
        if (numberOfAllElements < 0L) {
            throw new IllegalArgumentException("numberOfAllElements [" + numberOfAllElements + "] is less than NUMBER_OF_ALL_ELEMENTS_MIN_VALUE [" + 0L + "]");
        }
        if (limit == null) {
            throw new NullPointerException("limit cannot be null");
        }
        if ((long)elements.size() > limit.getMaxResults()) {
            throw new IllegalArgumentException("the size of the elements is greather than the max results of the limit");
        }
        if ((long)elements.size() > numberOfAllElements) {
            throw new IllegalArgumentException("the size of the elements is greather than the number of all elements");
        }
        this.elements = Collections.unmodifiableList(elements);
        this.numberOfAllElements = numberOfAllElements;
        this.limit = limit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitedResult other = (LimitedResult)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        if (this.limit == null ? other.limit != null : !this.limit.equals(other.limit)) {
            return false;
        }
        return this.numberOfAllElements == other.numberOfAllElements;
    }

    public List<T> getElements() {
        return this.elements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public long getNumberOfAllElements() {
        return this.numberOfAllElements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + (int)(this.numberOfAllElements ^ this.numberOfAllElements >>> 32);
        return result;
    }

    public String toString() {
        return "LimitedResult [elements=" + this.elements + ", numberOfAllElements=" + this.numberOfAllElements + ", limit=" + this.limit + "]";
    }
}

