/*
 * Decompiled with CFR 0.152.
 */
package org.everit.commons.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.everit.commons.selection.Limit;
import org.everit.commons.selection.LimitedResult;

public class Page<T extends Serializable>
extends LimitedResult<T> {
    private static final long serialVersionUID = -7857550936374542552L;
    private final long pageIndex;
    private final long lastAvailablePageIndex;

    public Page(List<T> elements, long numberOfAllElements, Limit limit) {
        super(elements, numberOfAllElements, limit);
        long firstResult = limit.getFirstResult();
        long pageSize = limit.getMaxResults();
        this.pageIndex = firstResult != 1L && pageSize != 1L && firstResult + 1L % pageSize == 0L ? firstResult / pageSize : firstResult / pageSize + 1L;
        this.lastAvailablePageIndex = numberOfAllElements % pageSize == 0L ? numberOfAllElements / pageSize : numberOfAllElements / pageSize + 1L;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        if (this.lastAvailablePageIndex != other.lastAvailablePageIndex) {
            return false;
        }
        return this.pageIndex == other.pageIndex;
    }

    public List<Long> getClickablePageIndexes(int maxNumberOfClickablePageIndexes) {
        ArrayList<Long> clickablePageIndexes = new ArrayList<Long>(maxNumberOfClickablePageIndexes);
        if (maxNumberOfClickablePageIndexes == 1) {
            clickablePageIndexes.add(this.pageIndex);
        } else if (maxNumberOfClickablePageIndexes > 1) {
            long lastClickablePageIndex;
            int before = (maxNumberOfClickablePageIndexes - 1) / 2;
            long firstClickablePageIndex = this.pageIndex - (long)before;
            long firstAvailablePageIndex = 1L;
            if (firstClickablePageIndex < firstAvailablePageIndex) {
                firstClickablePageIndex = firstAvailablePageIndex;
            }
            if ((lastClickablePageIndex = firstClickablePageIndex + (long)maxNumberOfClickablePageIndexes - 1L) > this.lastAvailablePageIndex) {
                long offset = lastClickablePageIndex - this.lastAvailablePageIndex;
                lastClickablePageIndex = this.lastAvailablePageIndex;
                if ((firstClickablePageIndex -= offset) < firstAvailablePageIndex) {
                    firstClickablePageIndex = firstAvailablePageIndex;
                }
            }
            for (long i = firstClickablePageIndex; i <= lastClickablePageIndex; ++i) {
                clickablePageIndexes.add(i);
            }
        }
        return clickablePageIndexes;
    }

    public long getFirstResult() {
        return this.getLimit().getFirstResult();
    }

    public long getLastAvailablePageIndex() {
        return this.lastAvailablePageIndex;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public long getPageSize() {
        return this.getLimit().getMaxResults();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.lastAvailablePageIndex ^ this.lastAvailablePageIndex >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "Page [pageIndex=" + this.pageIndex + ", lastAvailablePageIndex=" + this.lastAvailablePageIndex + "]";
    }
}

