/*
 * Decompiled with CFR 0.152.
 */
package org.everit.commons.selection;

import java.io.Serializable;
import org.everit.commons.selection.RangeException;
import org.everit.commons.selection.RangeRelation;

public class Range<T extends Comparable<? super T>>
implements Serializable {
    private static final long serialVersionUID = -4567444380490553673L;
    protected final T lowerBound;
    protected final T higherBound;
    protected boolean lowerInclusive = true;
    protected boolean higherInclusive = true;

    protected static int alignComparisionResultBasedOnInclusive(int value, boolean forLowerBound, boolean thisInclusive, boolean otherInclusive) {
        if (value == 0) {
            if (!thisInclusive && otherInclusive) {
                value = forLowerBound ? 1 : -1;
            } else if (thisInclusive && !otherInclusive) {
                value = forLowerBound ? -1 : 1;
            }
        }
        return value;
    }

    public Range(T lowerBound, T higherBound) {
        if (lowerBound != null && higherBound != null && lowerBound.compareTo(higherBound) > 0) {
            throw new IllegalArgumentException("lowerBound [" + lowerBound + "] is not lower than higherBound [" + higherBound + "]");
        }
        this.lowerBound = lowerBound;
        this.higherBound = higherBound;
    }

    public Range(T lowerBound, T higherBound, boolean lowerInclusive, boolean higherInclusive) {
        this(lowerBound, higherBound);
        this.lowerInclusive = lowerInclusive;
        this.higherInclusive = higherInclusive;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Range other = (Range)obj;
        if (this.higherInclusive != other.higherInclusive || this.lowerInclusive != other.lowerInclusive) {
            return false;
        }
        if (this.higherBound != null && !this.higherBound.equals(other.higherBound) || this.lowerBound != null && !this.lowerBound.equals(other.lowerBound)) {
            return false;
        }
        return (this.higherBound != null || other.higherBound == null) && (this.lowerBound != null || other.lowerBound == null);
    }

    public T getHigherBound() {
        return this.higherBound;
    }

    public T getLowerBound() {
        return this.lowerBound;
    }

    public RangeRelation getRelationTo(Range<T> other) {
        if (this == other) {
            return RangeRelation.IDENTICAL;
        }
        int lowerToOtherLower = this.lowerBound.compareTo(other.getLowerBound());
        lowerToOtherLower = Range.alignComparisionResultBasedOnInclusive(lowerToOtherLower, true, this.lowerInclusive, other.isLowerInclusive());
        int higherToOtherHigher = this.higherBound.compareTo(other.getHigherBound());
        higherToOtherHigher = Range.alignComparisionResultBasedOnInclusive(higherToOtherHigher, false, this.higherInclusive, other.isHigherInclusive());
        if (lowerToOtherLower == 0 && higherToOtherHigher == 0) {
            return RangeRelation.IDENTICAL;
        }
        if (lowerToOtherLower >= 0 && higherToOtherHigher <= 0) {
            return RangeRelation.CONTAINING;
        }
        if (lowerToOtherLower <= 0 && higherToOtherHigher >= 0) {
            return RangeRelation.CONTAINED;
        }
        if (lowerToOtherLower > 0) {
            int lowerToOtherHigher = this.lowerBound.compareTo(other.getHigherBound());
            if (!(lowerToOtherHigher != 0 || other.isHigherInclusive() && this.lowerInclusive)) {
                lowerToOtherHigher = 1;
            }
            if (lowerToOtherHigher > 0) {
                return RangeRelation.BEFORE;
            }
            return RangeRelation.BEFORE_OVERLAPPING;
        }
        if (higherToOtherHigher < 0) {
            int higherToOtherLower = this.higherBound.compareTo(other.getLowerBound());
            if (!(higherToOtherLower != 0 || other.isLowerInclusive() && this.higherInclusive)) {
                higherToOtherLower = -1;
            }
            if (higherToOtherLower < 0) {
                return RangeRelation.AFTER;
            }
            return RangeRelation.AFTER_OVERLAPPING;
        }
        throw new RangeException("failed to determine intervals' relation of this [" + this.toString() + "] and other [" + other.toString() + "]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.higherBound == null ? 0 : this.higherBound.hashCode());
        result = 31 * result + (this.higherInclusive ? 1231 : 1237);
        result = 31 * result + (this.lowerBound == null ? 0 : this.lowerBound.hashCode());
        result = 31 * result + (this.lowerInclusive ? 1231 : 1237);
        return result;
    }

    public Range<T> intersect(Range<T> other) {
        boolean higherInclusive;
        T higherBound;
        boolean lowerInclusive;
        T lowerBound;
        if (this.getRelationTo(other).isDistinct()) {
            return null;
        }
        int lowerComp = this.lowerBound.compareTo(other.lowerBound);
        if (lowerComp > 0) {
            lowerBound = this.lowerBound;
            lowerInclusive = this.lowerInclusive;
        } else if (lowerComp < 0) {
            lowerBound = other.lowerBound;
            lowerInclusive = other.lowerInclusive;
        } else {
            lowerBound = this.lowerBound;
            lowerInclusive = this.lowerInclusive || other.lowerInclusive;
        }
        int higherComp = this.higherBound.compareTo(other.higherBound);
        if (higherComp < 0) {
            higherBound = this.higherBound;
            higherInclusive = this.higherInclusive;
        } else if (higherComp > 0) {
            higherBound = other.higherBound;
            higherInclusive = other.higherInclusive;
        } else {
            higherBound = this.higherBound;
            higherInclusive = this.higherInclusive || other.higherInclusive;
        }
        return new Range<T>(lowerBound, higherBound, lowerInclusive, higherInclusive);
    }

    public boolean isHigherInclusive() {
        return this.higherInclusive;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public String toString() {
        return "Range [lowerBound=" + this.lowerBound + ", lowerInclusive=" + this.lowerInclusive + ", higherBound=" + this.higherBound + ", higherInclusive=" + this.higherInclusive + "]";
    }

    public Range<T> union(Range<T> other) {
        boolean higherInclusive;
        T higherBound;
        boolean lowerInclusive;
        T lowerBound;
        int lowerComp = this.lowerBound.compareTo(other.lowerBound);
        if (lowerComp < 0) {
            lowerBound = this.lowerBound;
            lowerInclusive = this.lowerInclusive;
        } else if (lowerComp > 0) {
            lowerBound = other.lowerBound;
            lowerInclusive = other.lowerInclusive;
        } else {
            lowerBound = this.lowerBound;
            lowerInclusive = this.lowerInclusive || other.lowerInclusive;
        }
        int higherComp = this.higherBound.compareTo(other.higherBound);
        if (higherComp > 0) {
            higherBound = this.higherBound;
            higherInclusive = this.higherInclusive;
        } else if (higherComp < 0) {
            higherBound = other.higherBound;
            higherInclusive = other.higherInclusive;
        } else {
            higherBound = this.higherBound;
            higherInclusive = this.higherInclusive || other.higherInclusive;
        }
        return new Range<T>(lowerBound, higherBound, lowerInclusive, higherInclusive);
    }
}

