/*
 * Decompiled with CFR 0.152.
 */
package org.everit.commons.selection.util;

import org.everit.commons.selection.lang.LongRange;

public class SecondRange
extends LongRange {
    private static final long serialVersionUID = 1459251233031508309L;

    public SecondRange(Long lowerBound, Long higherBound) {
        super(lowerBound, higherBound);
    }

    public SecondRange(Long lowerBound, Long higherBound, boolean lowerInclusive, boolean higherInclusive) {
        super(lowerBound, higherBound, lowerInclusive, higherInclusive);
    }

    public String getAsDuration() {
        boolean leadingSpaceNeeded;
        long duration;
        if (((Long)this.lowerBound).longValue() == ((Long)this.higherBound).longValue()) {
            return "0s";
        }
        long remaining = duration = this.getLength().longValue();
        long seconds = remaining % 60L;
        long minutes = (remaining /= 60L) % 60L;
        long hours = (remaining /= 60L) % 60L;
        StringBuilder sb = new StringBuilder();
        if (hours != 0L) {
            sb.append(Math.abs(hours)).append("h");
            leadingSpaceNeeded = true;
        } else {
            leadingSpaceNeeded = false;
        }
        if (minutes != 0L) {
            if (leadingSpaceNeeded) {
                sb.append(' ');
            }
            sb.append(Math.abs(minutes)).append("m");
            leadingSpaceNeeded = true;
        }
        if (seconds != 0L || minutes == 0L && hours == 0L) {
            if (leadingSpaceNeeded) {
                sb.append(' ');
            }
            sb.append(Math.abs(seconds)).append("s");
        }
        return sb.toString();
    }
}

