/*
 * Decompiled with CFR 0.152.
 */
package org.everit.config.conventions.checkstyle;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.LinkedList;
import java.util.List;

public class SuppressGeneratedHolder
extends Check {
    private static final String JAVAX_ANNOTATION_PREFIX = "javax.annotation.";
    private static final String GENERATED = "Generated";
    private static final ThreadLocal<List<Region>> GENERATED_REGIONS = new ThreadLocal();

    private static String getIdentifier(DetailAST ast) {
        if (ast != null) {
            if (ast.getType() == 58) {
                return ast.getText();
            }
            if (ast.getType() == 59) {
                return SuppressGeneratedHolder.getIdentifier(ast.getFirstChild()) + "." + SuppressGeneratedHolder.getIdentifier(ast.getLastChild());
            }
        }
        throw new IllegalArgumentException("Identifier AST expected: " + ast);
    }

    private static DetailAST getNthChild(DetailAST ast, int index) {
        DetailAST child = ast.getFirstChild();
        if (child != null) {
            for (int i = 0; i < index && child != null; child = child.getNextSibling(), ++i) {
            }
        }
        return child;
    }

    public static boolean isSuppressed(int line, int column) {
        List<Region> regions = GENERATED_REGIONS.get();
        if (regions != null) {
            for (Region region : regions) {
                boolean beforeEnd;
                boolean afterStart = region.firstLine < line || region.firstLine == line && region.firstColumn <= column;
                boolean bl = beforeEnd = region.lastLine > line || region.lastLine == line && region.lastColumn >= column;
                if (!afterStart || !beforeEnd) continue;
                return true;
            }
        }
        return false;
    }

    public void beginTree(DetailAST rootAST) {
        GENERATED_REGIONS.set(new LinkedList());
    }

    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    public void visitToken(DetailAST ast) {
        String identifier = SuppressGeneratedHolder.getIdentifier(SuppressGeneratedHolder.getNthChild(ast, 1));
        if (identifier.startsWith(JAVAX_ANNOTATION_PREFIX)) {
            identifier = identifier.substring(JAVAX_ANNOTATION_PREFIX.length());
        }
        if (GENERATED.equals(identifier)) {
            int lastColumn;
            int lastLine;
            DetailAST targetAST = null;
            DetailAST parentAST = ast.getParent();
            if (parentAST != null) {
                block0 : switch (parentAST.getType()) {
                    case 5: 
                    case 158: {
                        parentAST = parentAST.getParent();
                        if (parentAST == null) break;
                        switch (parentAST.getType()) {
                            case 8: 
                            case 9: 
                            case 10: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 21: 
                            case 154: 
                            case 155: 
                            case 157: {
                                targetAST = parentAST;
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
            if (targetAST == null) {
                this.log(ast, "suppress.generated.invalid.target", new Object[0]);
                return;
            }
            int firstLine = targetAST.getLineNo();
            int firstColumn = targetAST.getColumnNo();
            DetailAST nextAST = targetAST.getNextSibling();
            if (nextAST != null) {
                lastLine = nextAST.getLineNo();
                lastColumn = nextAST.getColumnNo() - 1;
            } else {
                lastLine = Integer.MAX_VALUE;
                lastColumn = Integer.MAX_VALUE;
            }
            GENERATED_REGIONS.get().add(new Region(firstLine, firstColumn, lastLine, lastColumn));
        }
    }

    private static class Region {
        private int firstLine;
        private int firstColumn;
        private int lastLine;
        private int lastColumn;

        public Region(int firstLine, int firstColumn, int lastLine, int lastColumn) {
            this.firstLine = firstLine;
            this.firstColumn = firstColumn;
            this.lastLine = lastLine;
            this.lastColumn = lastColumn;
        }
    }
}

