/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.dkim.ecm.internal;

import aQute.bnd.annotation.headers.ProvideCapability;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.everit.email.javamail.dkim.DKIMJavaMailMessageEnancer;
import org.everit.email.javamail.dkim.DKIMJavaMailMessageEnhancerConfig;
import org.everit.email.javamail.sender.JavaMailMessageEnhancer;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.BooleanAttribute;
import org.everit.osgi.ecm.annotation.attribute.PasswordAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributeOption;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.component.ConfigurationException;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.email.javamail.ecm.DKIMJavaMailMessageEnancer", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Message DKIMSigner Component", description="Java Mail Message enhancer implemantation that message sign with DKIM.")
@ManualService(value={JavaMailMessageEnhancer.class})
@ProvideCapability(ns="org.everit.osgi.ecm.component", value="class=${@class}")
public class DKIMJavaMailMessageEnancerComponent {
    private final DKIMJavaMailMessageEnhancerConfig config = new DKIMJavaMailMessageEnhancerConfig();
    private KeyStore keyStore;
    private String keyStorePassword;
    private String privateKeyAlias;
    private ServiceRegistration<JavaMailMessageEnhancer> serviceRegistration;

    @Activate
    public void activate(ComponentContext<DKIMJavaMailMessageEnancerComponent> componentContext) {
        this.config.privateKey(this.readPrivateKey());
        DKIMJavaMailMessageEnancer messageDKIMSigner = new DKIMJavaMailMessageEnancer(this.config);
        Hashtable properties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(JavaMailMessageEnhancer.class, (Object)messageDKIMSigner, properties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    private RSAPrivateKey readPrivateKey() {
        if (this.keyStore == null) {
            throw new ConfigurationException("Key store is null");
        }
        try {
            return (RSAPrivateKey)this.keyStore.getKey(this.privateKeyAlias, this.keyStorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ConfigurationException("Problem to get RSAPrivateKey");
        }
    }

    @StringAttribute(attributeId="additionalHeaders", optional=true, label="Addition headers to sign", description="Additional headers that should be signed if available. These headers are added to the ones defined as default headers in DkimSigner class.")
    public void setAdditionalHeadersToSign(String[] additionalHeadersToSign) {
        this.config.additionalHeadersToSign = additionalHeadersToSign == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(additionalHeadersToSign));
    }

    @StringAttribute(attributeId="bodyCanonicalization", label="Body canonicalization", description="The canonicalization to be used for the body. More information in RFC4871.", optional=true, options={@StringAttributeOption(value="SIMPLE", label="SIMPLE"), @StringAttributeOption(value="RELAXED", label="RELAXED")})
    public void setBodyCanonicalization(String bodyCanonicalization) {
        this.config.bodyCanonicalization = bodyCanonicalization != null ? Canonicalization.valueOf((String)bodyCanonicalization) : null;
    }

    @StringAttribute(attributeId="excludedHeaders", optional=true, label="Addition headers to sign", description="Headers that should be excluded from the signature. By default, the headers that are defined in the DkimSigner class and the ones defined in additionalHeadersToSign configuration are used.")
    public void setExcludedHeadersFromSign(String[] excludedHeadersFromSign) {
        this.config.excludedHeadersFromSign = excludedHeadersFromSign == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(excludedHeadersFromSign));
    }

    @StringAttribute(attributeId="headerCanonicalization", label="Header canonicalization", description="The canonicalization to be used for the header. More information in RFC4871.", optional=true, options={@StringAttributeOption(value="SIMPLE", label="SIMPLE"), @StringAttributeOption(value="RELAXED", label="RELAXED")})
    public void setHeaderCanonicalization(String headerCanonicalization) {
        this.config.headerCanonicalization = headerCanonicalization != null ? Canonicalization.valueOf((String)headerCanonicalization) : null;
    }

    @StringAttribute(attributeId="identity", optional=true, label="Identity", description="Identity of the user or agent (e.g., a mailing list manager) on behalf of which this message is signed. More information in RFC4871.")
    public void setIdentity(String identity) {
        this.config.identity = identity;
    }

    @ServiceRef(attributeId="keyStore.target", referenceId="keyStore", label="Key store", description="The key store that contains the RSAPrivateKey to DKIM signing.")
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @PasswordAttribute(attributeId="keyStorePassword", optional=true, label="Key Store Password", description="The password to KeyStore.")
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @BooleanAttribute(attributeId="useLengthParam", defaultValue={false}, label="Length Param", description="Use length parameter to signurate or not. More information in RFC4871.")
    public void setLengthParam(boolean lengthParam) {
        this.config.lengthParam = lengthParam;
    }

    @StringAttribute(attributeId="privateKeyAlias", label="Private Key Alias", description="The alias name of the private key in the KeyStore.")
    public void setPrivateKeyAlias(String privateKeyAlias) {
        this.privateKeyAlias = privateKeyAlias;
    }

    @StringAttribute(attributeId="selector", label="Selector", description="The selector subdividing the namespace for the domain tag. More information in RFC4871.")
    public void setSelector(String selector) {
        this.config.selector = selector;
    }

    @StringAttribute(attributeId="signingAlgorithm", optional=true, label="Signing Algorithm", description="The algorithm that used to generate the signature. More information in RFC4871.", options={@StringAttributeOption(value="SHA256_WITH_RSA", label="SHA256_WITH_RSA"), @StringAttributeOption(value="SHA1_WITH_RSA", label="SHA1_WITH_RSA")})
    public void setSigningAlgorithm(String signingAlgorithm) {
        this.config.signingAlgorithm = signingAlgorithm != null ? SigningAlgorithm.valueOf((String)signingAlgorithm) : null;
    }

    @StringAttribute(attributeId="signingDomain", label="Signing domain", description="The domain of the signing entity. More information in RFC4871.")
    public void setSigningDomain(String signingDomain) {
        this.config.signingDomain = signingDomain;
    }

    @BooleanAttribute(attributeId="zParam", defaultValue={false}, label="Z Param", description="Use z parameter to signurate or not. More information in RFC4871.")
    public void setzParam(boolean zParam) {
        this.config.zParam = zParam;
    }
}

