/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.dkim;

import java.util.Objects;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import org.everit.email.javamail.dkim.DKIMJavaMailMessageEnhancerConfig;
import org.everit.email.javamail.sender.JavaMailMessageEnhancer;

public class DKIMJavaMailMessageEnancer
implements JavaMailMessageEnhancer {
    private final DkimSigner dkimSigner;

    public DKIMJavaMailMessageEnancer(DKIMJavaMailMessageEnhancerConfig config) {
        Objects.requireNonNull(config, "config cannot be null");
        Objects.requireNonNull(config.signingDomain, "signingDomain cannot be null");
        Objects.requireNonNull(config.selector, "selector cannot be null");
        Objects.requireNonNull(config.privateKey, "privateKey cannot be null");
        Objects.requireNonNull(config.additionalHeadersToSign, "Additional headers set cannot be null");
        Objects.requireNonNull(config.excludedHeadersFromSign, "Excluded headers set cannot be null");
        this.dkimSigner = new DkimSigner(config.signingDomain, config.selector, config.privateKey);
        if (config.identity != null) {
            this.dkimSigner.setIdentity(config.identity);
        }
        if (config.headerCanonicalization != null) {
            this.dkimSigner.setHeaderCanonicalization(config.headerCanonicalization);
        }
        if (config.bodyCanonicalization != null) {
            this.dkimSigner.setBodyCanonicalization(config.bodyCanonicalization);
        }
        if (config.signingAlgorithm != null) {
            this.dkimSigner.setSigningAlgorithm(config.signingAlgorithm);
        }
        this.dkimSigner.setLengthParam(config.lengthParam);
        this.dkimSigner.setZParam(config.zParam);
        for (String header : config.additionalHeadersToSign) {
            this.dkimSigner.addHeaderToSign(header);
        }
        for (String header : config.excludedHeadersFromSign) {
            this.dkimSigner.removeHeaderToSign(header);
        }
    }

    public MimeMessage enhance(MimeMessage message) {
        try {
            return new DkimMessage(message, this.dkimSigner);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

