/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.ecm.internal;

import java.util.Hashtable;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import org.everit.email.javamail.ecm.internal.PasswordAuthenticator;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.Update;
import org.everit.osgi.ecm.annotation.attribute.PasswordAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.email.javamail.ecm.PasswordAuthenticator", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit JavaMail Password Authenticator", description="Registers an Authenticator as OSGi service that uses the configured username-password pair for authentication.")
@ManualServices(value={@ManualService(value={Authenticator.class})})
@ExtendComponent
public class JavamailPasswordAuthenticatorComponent {
    private String password;
    private PasswordAuthenticator passwordAuthenticator;
    private ServiceRegistration<Authenticator> serviceRegistration;
    private String userName;

    @Activate
    public void activate(ComponentContext<JavamailPasswordAuthenticatorComponent> componentContext) {
        this.passwordAuthenticator = new PasswordAuthenticator(new PasswordAuthentication(this.userName, this.password));
        Hashtable properties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(Authenticator.class, (Object)this.passwordAuthenticator, properties);
    }

    @Deactivate
    public void deactivate() {
        this.serviceRegistration.unregister();
    }

    @PasswordAttribute(attributeId="password", optional=true, dynamic=true, label="Password", description="The password that is used during the authentication. The attribute can be dinamically updated without restarting the component.", priority=1.0f)
    public void setPassword(String password) {
        this.password = password;
    }

    @StringAttribute(attributeId="userName", optional=true, dynamic=true, label="User name", description="The user name that is used during the authentication. The attribute can be dinamically updated without restarting the component.", priority=0.0f)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Update
    public void update() {
        this.passwordAuthenticator.setPasswordauthentication(new PasswordAuthentication(this.userName, this.password));
    }
}

