/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.ecm.sender.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.mail.Session;
import org.everit.email.javamail.sender.JavaMailEmailSender;
import org.everit.email.javamail.sender.JavaMailMessageEnhancer;
import org.everit.email.sender.EmailSender;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.ThreeStateBoolean;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.email.javamail.ecm.sender.JavamailEmailSender", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit JavaMail Email Sender", description="JSR 919 implementation of Everit Email Sender")
@ManualServices(value={@ManualService(value={EmailSender.class})})
@ExtendComponent
public class JavamailEmailSenderComponent {
    private List<JavaMailMessageEnhancer> enhancers = Collections.emptyList();
    private ServiceRegistration<EmailSender> serviceRegistration;
    private Session session;

    @Activate
    public void activate(ComponentContext<JavamailEmailSenderComponent> componentContext) {
        JavaMailEmailSender emailSender = new JavaMailEmailSender(this.session, this.enhancers);
        Hashtable properties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(EmailSender.class, (Object)emailSender, properties);
    }

    @Deactivate
    public void deactivate() {
        this.serviceRegistration.unregister();
    }

    @ServiceRef(attributeId="enhancers.target", referenceId="enhancers", optional=true, multiple=ThreeStateBoolean.TRUE, label="Enhancers", description="Java Mail Message Enhancers that are used to enhance javax.mail.internet.MimeMessage.")
    public void setEnhancers(JavaMailMessageEnhancer[] enhancers) {
        this.enhancers = enhancers != null && enhancers.length > 0 ? Arrays.asList(enhancers) : Collections.emptyList();
    }

    @ServiceRef(referenceId="session", defaultValue={""}, label="Session", description="Java Mail Session that is used to create Transport instances.")
    public void setSession(Session session) {
        this.session = session;
    }
}

