/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.ecm.internal;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.component.ConfigurationException;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.email.javamail.ecm.Session", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit JavaMail Email Session", description="Component that registers a configured JSR 919 Session")
@ManualServices(value={@ManualService(value={Session.class})})
@ExtendComponent
public final class JavamailSessionComponent {
    private Authenticator authenticator;
    private String properties;
    private ServiceRegistration<Session> serviceRegistration;

    @Activate
    public void activate(ComponentContext<JavamailSessionComponent> componentContext) {
        Properties props = new Properties();
        StringReader stringReader = new StringReader(this.properties);
        try {
            props.load(stringReader);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not load Session properties", (Throwable)e);
        }
        Session session = this.authenticator == null ? Session.getInstance((Properties)props) : Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        Hashtable serviceProps = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(Session.class, (Object)session, serviceProps);
    }

    @Deactivate
    public void deactivate() {
        this.serviceRegistration.unregister();
    }

    @ServiceRef(referenceId="authenticator", optional=true, label="Authenticator", description="Authenticator that is used to authenticate to the email server (SMTP).")
    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @StringAttribute(attributeId="properties", optional=false, label="Properties", description="Configuration of the Session in properties file format.")
    public void setProperties(String properties) {
        this.properties = properties;
    }
}

