/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.sender.internal;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.everit.email.Email;
import org.everit.email.javamail.util.MessageGenerator;
import org.everit.email.javamail.util.UncheckedMessagingException;
import org.everit.email.sender.BulkEmailSender;

public class JavaMailBulkEmailSender
implements BulkEmailSender {
    private final MessageGenerator messageGenerator;
    private Transport transport;

    public JavaMailBulkEmailSender(Session session) {
        try {
            this.transport = session.getTransport();
            this.transport.connect();
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
        this.messageGenerator = new MessageGenerator();
    }

    public void close() {
        try {
            this.transport.close();
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
    }

    public void sendEmail(Email email) {
        Message message = this.messageGenerator.generateMessage(email);
        try {
            this.transport.sendMessage(message, message.getAllRecipients());
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
    }
}

