/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.sender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.Session;
import org.everit.email.Email;
import org.everit.email.javamail.sender.JavaMailMessageEnhancer;
import org.everit.email.javamail.sender.internal.JavaMailBulkEmailSender;
import org.everit.email.sender.BulkEmailSender;
import org.everit.email.sender.EmailSender;

public class JavaMailEmailSender
implements EmailSender {
    private final List<JavaMailMessageEnhancer> enhancers;
    private final Session session;

    public JavaMailEmailSender(Session session) {
        this(session, new ArrayList<JavaMailMessageEnhancer>(0));
    }

    public JavaMailEmailSender(Session session, Collection<JavaMailMessageEnhancer> enhancers) {
        this.session = session;
        this.enhancers = new ArrayList<JavaMailMessageEnhancer>(enhancers);
    }

    public BulkEmailSender openBulkEmailSender() {
        return new JavaMailBulkEmailSender(this.session, this.enhancers);
    }

    public void sendEmail(Email email) {
        try (BulkEmailSender bulkEmailSender = this.openBulkEmailSender();){
            bulkEmailSender.sendEmail(email);
        }
    }
}

