/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.sender.internal;

import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.everit.email.Email;
import org.everit.email.javamail.sender.JavaMailMessageEnhancer;
import org.everit.email.javamail.util.MimeMessageGenerator;
import org.everit.email.javamail.util.UncheckedMessagingException;
import org.everit.email.sender.BulkEmailSender;

public class JavaMailBulkEmailSender
implements BulkEmailSender {
    private final List<JavaMailMessageEnhancer> enhancers;
    private final MimeMessageGenerator mimeMessageGenerator;
    private Transport transport;

    public JavaMailBulkEmailSender(Session session, List<JavaMailMessageEnhancer> enhancers) {
        try {
            this.transport = session.getTransport();
            this.transport.connect();
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
        this.mimeMessageGenerator = new MimeMessageGenerator();
        this.enhancers = enhancers;
    }

    public void close() {
        try {
            this.transport.close();
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
    }

    public void sendEmail(Email email) {
        MimeMessage message = this.mimeMessageGenerator.generateMimeMessage(email);
        for (JavaMailMessageEnhancer enhancer : this.enhancers) {
            message = enhancer.enhance(message);
        }
        try {
            this.transport.sendMessage((Message)message, message.getAllRecipients());
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
    }
}

