/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.javamail.util;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.everit.email.Attachment;
import org.everit.email.Email;
import org.everit.email.EmailAddress;
import org.everit.email.javamail.util.AttachmentDataSource;
import org.everit.email.javamail.util.UncheckedMessagingException;

public class MimeMessageGenerator {
    private static final String DEFAULT_CHARSET = "utf-8";
    private String charset = "utf-8";

    private void addAttachments(Email email, MimeMultipart mixedMultipart) throws MessagingException {
        for (Attachment attachment : email.attachments) {
            MimeBodyPart attachmentBodyPart = new MimeBodyPart();
            AttachmentDataSource dataSource = new AttachmentDataSource(attachment);
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            attachmentBodyPart.setDisposition("attachment");
            attachmentBodyPart.setFileName(attachment.name);
            mixedMultipart.addBodyPart((BodyPart)attachmentBodyPart);
        }
    }

    private void applyHeadersOnMessage(MimeMessage message, Email mailParams) throws MessagingException {
        message.setSubject(mailParams.subject, this.charset);
        message.setFrom((Address)this.convertAddress(mailParams.from));
        message.setRecipients(Message.RecipientType.TO, (Address[])this.convertAddresses(mailParams.recipients.to));
        message.setRecipients(Message.RecipientType.CC, (Address[])this.convertAddresses(mailParams.recipients.cc));
        message.setRecipients(Message.RecipientType.BCC, (Address[])this.convertAddresses(mailParams.recipients.bcc));
    }

    private InternetAddress convertAddress(EmailAddress emailAddress) {
        try {
            return new InternetAddress(emailAddress.address, emailAddress.personal, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private InternetAddress[] convertAddresses(Collection<EmailAddress> addresses) {
        if (addresses.size() == 0) {
            return new InternetAddress[0];
        }
        InternetAddress[] result = new InternetAddress[addresses.size()];
        int i = 0;
        for (EmailAddress emailAddress : addresses) {
            result[i] = this.convertAddress(emailAddress);
            ++i;
        }
        return result;
    }

    private Multipart createAlternativeMultiPart(Email email) throws MessagingException {
        BodyPart htmlBodyPart;
        MimeMultipart alternativePart = new MimeMultipart("alternative");
        alternativePart.addBodyPart(this.createTextBodyPart(email));
        if (email.htmlContent.inlineImageByCidMap.size() == 0) {
            htmlBodyPart = this.createHtmlBodyPart(email);
        } else {
            htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent(this.createRelatedMultiPart(email));
        }
        alternativePart.addBodyPart(htmlBodyPart);
        return alternativePart;
    }

    private Multipart createComplexContent(Email email) throws MessagingException {
        if (email.attachments.size() == 0) {
            if (email.textContent != null && email.htmlContent != null) {
                return this.createAlternativeMultiPart(email);
            }
            return this.createRelatedMultiPart(email);
        }
        MimeMultipart mixedMultipart = new MimeMultipart("mixed");
        if (email.htmlContent == null) {
            mixedMultipart.addBodyPart(this.createTextBodyPart(email));
        } else if (email.textContent == null && email.htmlContent.inlineImageByCidMap.size() == 0) {
            mixedMultipart.addBodyPart(this.createHtmlBodyPart(email));
        } else {
            MimeBodyPart coverBodyPart = new MimeBodyPart();
            Multipart coverMultipart = email.textContent != null ? this.createAlternativeMultiPart(email) : this.createRelatedMultiPart(email);
            coverBodyPart.setContent(coverMultipart);
            mixedMultipart.addBodyPart((BodyPart)coverBodyPart);
        }
        this.addAttachments(email, mixedMultipart);
        return mixedMultipart;
    }

    private BodyPart createHtmlBodyPart(Email email) throws MessagingException {
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        htmlBodyPart.setContent((Object)email.htmlContent.html, "text/html; charset=" + this.charset);
        return htmlBodyPart;
    }

    private Multipart createRelatedMultiPart(Email email) throws MessagingException {
        MimeMultipart relatedMultipart = new MimeMultipart("related");
        relatedMultipart.addBodyPart(this.createHtmlBodyPart(email));
        Set inlineImageEntries = email.htmlContent.inlineImageByCidMap.entrySet();
        for (Map.Entry inlineImageEntry : inlineImageEntries) {
            String cid = (String)inlineImageEntry.getKey();
            Attachment imageAttachment = (Attachment)inlineImageEntry.getValue();
            MimeBodyPart imageBodyPart = new MimeBodyPart();
            imageBodyPart.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(imageAttachment)));
            imageBodyPart.setHeader("Content-ID", "<" + cid + ">");
            relatedMultipart.addBodyPart((BodyPart)imageBodyPart);
        }
        return relatedMultipart;
    }

    private BodyPart createTextBodyPart(Email email) throws MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)email.textContent, "text/plain; charset=utf-8");
        return textPart;
    }

    public MimeMessage generateMimeMessage(Email email) {
        this.validateMailParams(email);
        MimeMessage message = new MimeMessage((Session)null);
        try {
            this.applyHeadersOnMessage(message, email);
            if (this.isSimpleMessage(email)) {
                if (email.htmlContent == null) {
                    message.setText(email.textContent, this.charset);
                } else {
                    message.setContent((Object)email.htmlContent.html, "text/html; charset=utf-8");
                }
                return message;
            }
            Multipart complexContentMultiPart = this.createComplexContent(email);
            message.setContent(complexContentMultiPart);
        }
        catch (MessagingException e) {
            throw new UncheckedMessagingException(e);
        }
        return message;
    }

    private boolean isSimpleMessage(Email mailParams) {
        if (mailParams.attachments.size() > 0) {
            return false;
        }
        if (mailParams.htmlContent == null) {
            return true;
        }
        return mailParams.textContent == null && mailParams.htmlContent.inlineImageByCidMap.size() == 0;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    private void validateMailParams(Email email) {
        Objects.requireNonNull(email, "mailParams cannot be null");
        Objects.requireNonNull(email.subject, "Subject must be defined");
        Objects.requireNonNull(email.from, "Email sender must be defined");
        Objects.requireNonNull(email.attachments, "Attachment collection cannot be null");
        Objects.requireNonNull(email.recipients, "Recipients must not be null");
        Objects.requireNonNull(email.recipients.bcc, "BCC collection cannot be null");
        Objects.requireNonNull(email.recipients.cc, "CC collection cannot be null");
        Objects.requireNonNull(email.recipients.to, "Recipients collection cannot be null");
        if (email.recipients.to.size() == 0) {
            throw new IllegalArgumentException("At least one recipient must be defined");
        }
        if (email.htmlContent == null && email.textContent == null) {
            throw new IllegalArgumentException("Neither HTML nor Text content is defined. At least one of them should be declared.");
        }
        if (email.htmlContent != null) {
            if (email.htmlContent.html == null) {
                throw new IllegalArgumentException("Content is not defined for HTML body.");
            }
            if (email.htmlContent.inlineImageByCidMap == null) {
                throw new IllegalArgumentException("Inline image map for html body must not be null");
            }
        }
    }
}

