/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.queue.ecm.internal;

import aQute.bnd.annotation.headers.ProvideCapability;
import java.util.Hashtable;
import org.everit.email.queue.EmailQueue;
import org.everit.email.queue.EmailQueueConfiguration;
import org.everit.email.queue.PassOnJobConfiguration;
import org.everit.email.sender.EmailSender;
import org.everit.email.store.EmailStore;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.transaction.propagator.TransactionPropagator;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.email.queue.ecm.EmailQueue", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Email Queue", description="ECM component for Email Queue.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Email Queue Component"}, priority=0.0f, label="Service Description", description="The description of this component configuration.It is used to easily identify the service registered by this component.")})
@ManualService(value={EmailStore.class, Runnable.class})
@ProvideCapability(ns="org.everit.osgi.ecm.component", value="class=${@class}")
public class EmailQueueComponent {
    private int batchMaxSize;
    private ServiceRegistration<Runnable> createPassOnJobServiceRegistration;
    private EmailSender emailSender;
    private ServiceRegistration<EmailSender> emailSenderServiceRegistration;
    private EmailStore emailStore;
    private QuerydslSupport querydslSupport;
    private TransactionPropagator transactionPropagator;

    @Activate
    public void activate(ComponentContext<EmailQueueComponent> componentContext) {
        EmailQueueConfiguration emailQueueParameter = new EmailQueueConfiguration().emailSender(this.emailSender).emailStore(this.emailStore).querydslSupport(this.querydslSupport).transactionPropagator(this.transactionPropagator);
        EmailQueue emailQueue = new EmailQueue(emailQueueParameter);
        Hashtable properties = new Hashtable(componentContext.getProperties());
        this.emailSenderServiceRegistration = componentContext.registerService(EmailSender.class, (Object)emailQueue, properties);
        PassOnJobConfiguration param = new PassOnJobConfiguration().batchMaxSize(this.batchMaxSize);
        Runnable createPassOnJob = emailQueue.createPassOnJob(param);
        this.createPassOnJobServiceRegistration = componentContext.registerService(Runnable.class, (Object)createPassOnJob, properties);
    }

    @Deactivate
    public void deactivate() {
        if (this.emailSenderServiceRegistration != null) {
            this.emailSenderServiceRegistration.unregister();
        }
        if (this.createPassOnJobServiceRegistration != null) {
            this.createPassOnJobServiceRegistration.unregister();
        }
    }

    @IntegerAttribute(attributeId="batchMaxSize", defaultValue={10}, priority=5.0f, label="Batch max size", description="The maximum number of emails that is passed on to the sink in a job call.")
    public void setBatchMaxSize(int max) {
        this.batchMaxSize = max;
    }

    @ServiceRef(attributeId="emailSender.target", defaultValue={""}, attributePriority=4.0f, label="Email sender", description="OSGi service filter for org.everit.email.sender.EmailSender.")
    public void setEmailSender(EmailSender emailSender) {
        this.emailSender = emailSender;
    }

    @ServiceRef(attributeId="emailStore.target", defaultValue={""}, attributePriority=3.0f, label="Email store", description="OSGi service filter for org.everit.email.store.EmailStore.")
    public void setEmailStore(EmailStore emailStore) {
        this.emailStore = emailStore;
    }

    @ServiceRef(attributeId="querydslSupport.target", defaultValue={""}, attributePriority=1.0f, label="Querydsl support", description="OSGi service filter for org.everit.persistence.querydsl.support.QuerydslSupport.")
    public void setQuerydslSupport(QuerydslSupport querydslSupport) {
        this.querydslSupport = querydslSupport;
    }

    @ServiceRef(attributeId="transactionPropagator.target", defaultValue={""}, attributePriority=2.0f, label="Transaction propagator", description="OSGi service filter for org.everit.transaction.propagator.TransactionPropagator.")
    public void setTransactionPropagator(TransactionPropagator transactionPropagator) {
        this.transactionPropagator = transactionPropagator;
    }
}

