/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.queue;

import java.util.Objects;
import org.everit.email.Email;
import org.everit.email.queue.EmailQueueConfiguration;
import org.everit.email.queue.PassOnJobConfiguration;
import org.everit.email.queue.internal.EmailQueueBulkEmailSender;
import org.everit.email.sender.BulkEmailSender;
import org.everit.email.sender.EmailSender;

public class EmailQueue
implements EmailSender {
    private EmailQueueBulkEmailSender emailQueueBulkEmailSender;

    public EmailQueue(EmailQueueConfiguration emailQueueParam) {
        Objects.requireNonNull(emailQueueParam, "emailQueueParam cannot be null.");
        Objects.requireNonNull(emailQueueParam.emailSender, "sink cannot be null.");
        Objects.requireNonNull(emailQueueParam.emailStore, "emailStore cannot be null.");
        Objects.requireNonNull(emailQueueParam.querydslSupport, "querydslSupport cannot be null.");
        Objects.requireNonNull(emailQueueParam.transactionPropagator, "transactionPropagator cannot be null.");
        this.emailQueueBulkEmailSender = new EmailQueueBulkEmailSender(emailQueueParam.emailSender, emailQueueParam.emailStore, emailQueueParam.querydslSupport, emailQueueParam.transactionPropagator);
    }

    public Runnable createPassOnJob(PassOnJobConfiguration param) {
        Objects.requireNonNull(param, "param cannot be null.");
        return this.emailQueueBulkEmailSender.createPassOnJob(param);
    }

    public BulkEmailSender openBulkEmailSender() {
        return this.emailQueueBulkEmailSender;
    }

    public void sendEmail(Email mail) {
        try (BulkEmailSender bulkEmailSender = this.openBulkEmailSender();){
            bulkEmailSender.sendEmail(mail);
        }
    }
}

