/*
 * Decompiled with CFR 0.152.
 */
package org.everit.email.queue.internal;

import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.dml.SQLDeleteClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.Projections;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import org.everit.email.Email;
import org.everit.email.queue.PassOnJobConfiguration;
import org.everit.email.queue.schema.qdsl.QEmailQueue;
import org.everit.email.sender.BulkEmailSender;
import org.everit.email.sender.EmailSender;
import org.everit.email.store.EmailStore;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.transaction.propagator.TransactionPropagator;

public class EmailQueueBulkEmailSender
implements BulkEmailSender {
    private final EmailStore emailStore;
    private final QuerydslSupport querydslSupport;
    private final EmailSender sink;
    private final TransactionPropagator transactionPropagator;

    public EmailQueueBulkEmailSender(EmailSender sink, EmailStore emailStore, QuerydslSupport querydslSupport, TransactionPropagator transactionPropagator) {
        this.sink = sink;
        this.emailStore = emailStore;
        this.querydslSupport = querydslSupport;
        this.transactionPropagator = transactionPropagator;
    }

    public void close() {
    }

    public Runnable createPassOnJob(PassOnJobConfiguration config) {
        return () -> this.transactionPropagator.required(() -> {
            List<QueuedEmailDTO> queuedEmails = this.selectQueuedEmailForUpdate(config.batchMaxSize);
            try (BulkEmailSender bulkEmailSender = this.sink.openBulkEmailSender();){
                for (QueuedEmailDTO queuedEmail : queuedEmails) {
                    Email mail = this.emailStore.read(queuedEmail.storedEmailId);
                    bulkEmailSender.sendEmail(mail);
                    this.deleteQueuedEmail(queuedEmail.queuedEmailId);
                    this.emailStore.remove(queuedEmail.storedEmailId);
                }
            }
        });
    }

    private void deleteQueuedEmail(long queuedEmailId) {
        this.querydslSupport.execute((connection, configuration) -> {
            QEmailQueue qEmailQueue = QEmailQueue.emailQueue;
            return new SQLDeleteClause(connection, configuration, (RelationalPath)qEmailQueue).where((Predicate)qEmailQueue.queuedEmailId.eq((Object)queuedEmailId)).execute();
        });
    }

    private void enqueueStoredEmailId(long storedEmailId) {
        this.querydslSupport.execute((connection, configuration) -> {
            QEmailQueue qEmailQueue = QEmailQueue.emailQueue;
            return new SQLInsertClause(connection, configuration, (RelationalPath)qEmailQueue).set((Path)qEmailQueue.storedEmailId, (Object)storedEmailId).set((Path)qEmailQueue.timestamp_, (Object)Timestamp.from(Instant.now())).execute();
        });
    }

    private List<QueuedEmailDTO> selectQueuedEmailForUpdate(int limit) {
        return (List)this.querydslSupport.execute((connection, configuration) -> {
            QEmailQueue qEmailQueue = QEmailQueue.emailQueue;
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery(connection, configuration).from((Expression)qEmailQueue)).orderBy(new OrderSpecifier[]{qEmailQueue.timestamp_.asc(), qEmailQueue.queuedEmailId.asc()})).limit((long)limit)).forUpdate()).list((Expression)Projections.fields(QueuedEmailDTO.class, (Expression[])new Expression[]{qEmailQueue.queuedEmailId, qEmailQueue.storedEmailId}));
        });
    }

    public void sendEmail(Email mail) {
        this.transactionPropagator.required(() -> {
            long storedEmailId = this.emailStore.store(mail);
            this.enqueueStoredEmailId(storedEmailId);
        });
    }

    public static class QueuedEmailDTO {
        public long queuedEmailId;
        public long storedEmailId;
    }
}

