/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.jettyclient.internal;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.api.ContentProvider;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AsyncCallback;

public class HttpRequestBodyAsyncContentProvider
implements AsyncContentProvider,
ContentProvider.Typed,
Closeable {
    private final org.everit.http.client.async.AsyncContentProvider body;
    private boolean completed = false;
    private Throwable errorFromProvider = null;
    private Executor executor;
    private AtomicBoolean iteratorServed = new AtomicBoolean(false);
    private AsyncCallback lastAsyncCallback = null;
    private ByteBuffer lastChunk = null;
    private AsyncContentProvider.Listener listener = null;
    private Object mutex = new Object();
    private Consumer<Throwable> requestAbortAction;

    public HttpRequestBodyAsyncContentProvider(org.everit.http.client.async.AsyncContentProvider body, Consumer<Throwable> requestAbortAction, Executor executor) {
        this.body = body;
        this.requestAbortAction = requestAbortAction;
        this.executor = executor;
        body.onSuccess(() -> {
            AsyncContentProvider.Listener tmpListener;
            Object object = this.mutex;
            synchronized (object) {
                this.completed = true;
                tmpListener = this.listener;
            }
            if (tmpListener != null) {
                tmpListener.onContent();
            }
        });
        body.onError(this::handleErrorFromProvider);
        body.onContent((buffer, callback) -> {
            AsyncContentProvider.Listener tmpListener;
            Object object = this.mutex;
            synchronized (object) {
                this.lastAsyncCallback = callback;
                this.lastChunk = buffer;
                tmpListener = this.listener;
            }
            if (tmpListener != null) {
                tmpListener.onContent();
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.body.close();
    }

    public String getContentType() {
        if (this.body.getContentType().isPresent()) {
            return ((MediaType)this.body.getContentType().get()).toString();
        }
        return null;
    }

    public long getLength() {
        if (this.body.getContentLength().isPresent()) {
            return (Long)this.body.getContentLength().get();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleErrorFromProvider(Throwable error) {
        boolean callAbort = false;
        Object object = this.mutex;
        synchronized (object) {
            if (this.errorFromProvider == null) {
                this.errorFromProvider = error;
                callAbort = true;
            }
        }
        if (callAbort) {
            this.requestAbortAction.accept(error);
        }
    }

    public synchronized Iterator<ByteBuffer> iterator() {
        if (this.iteratorServed.compareAndSet(false, true)) {
            return new HttpBodyAsyncContentProviderIterator();
        }
        return Collections.emptyIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(AsyncContentProvider.Listener listener) {
        boolean tmpCompleted;
        ByteBuffer tmpLastChunk;
        Object object = this.mutex;
        synchronized (object) {
            this.listener = listener;
            tmpLastChunk = this.lastChunk;
            tmpCompleted = this.completed;
        }
        if (tmpLastChunk != null || tmpCompleted) {
            listener.onContent();
        }
    }

    private class HttpBodyAsyncContentProviderIterator
    implements Iterator<ByteBuffer>,
    Closeable {
        private HttpBodyAsyncContentProviderIterator() {
        }

        @Override
        public void close() throws IOException {
            HttpRequestBodyAsyncContentProvider.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = HttpRequestBodyAsyncContentProvider.this.mutex;
            synchronized (object) {
                return !HttpRequestBodyAsyncContentProvider.this.completed || HttpRequestBodyAsyncContentProvider.this.lastChunk != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer next() {
            Object object = HttpRequestBodyAsyncContentProvider.this.mutex;
            synchronized (object) {
                if (!this.hasNext()) {
                    return null;
                }
                ByteBuffer item = HttpRequestBodyAsyncContentProvider.this.lastChunk;
                HttpRequestBodyAsyncContentProvider.this.lastChunk = null;
                AsyncCallback callback = HttpRequestBodyAsyncContentProvider.this.lastAsyncCallback;
                HttpRequestBodyAsyncContentProvider.this.lastAsyncCallback = null;
                if (callback != null) {
                    HttpRequestBodyAsyncContentProvider.this.executor.execute(() -> ((AsyncCallback)callback).processed());
                }
                return item;
            }
        }
    }
}

