/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.jettyclient.internal;

import io.reactivex.SingleEmitter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.util.Callback;
import org.everit.http.client.HttpResponse;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AsyncCallback;
import org.everit.http.client.async.AsyncContentListener;
import org.everit.http.client.async.AsyncContentProvider;

public class JettyResponseListenerToEveritAsyncProvider
implements Response.HeadersListener,
Response.AsyncContentListener,
Response.CompleteListener,
Response.FailureListener,
Response.SuccessListener {
    private JettyToHttpResponseAsyncContentProvider contentProvider;
    private boolean errorBeforeHeaders = false;
    private Object mutex = new Object();
    private Response response;
    private final SingleEmitter<HttpResponse> singleEmitter;

    private static Map<String, String> convertHeaderFieldToHeaderMap(HttpFields headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (HttpField header : headers) {
            result.put(header.getName(), header.getValue());
        }
        return result;
    }

    public JettyResponseListenerToEveritAsyncProvider(SingleEmitter<HttpResponse> singleEmitter) {
        this.singleEmitter = singleEmitter;
    }

    public boolean isHeaderProcessedOrFailed() {
        return this.contentProvider != null || this.errorBeforeHeaders;
    }

    public void onComplete(Result result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContent(Response response, ByteBuffer content, Callback callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.response = response;
            if (this.contentProvider.contentListener == null) {
                this.contentProvider.unprocessedContent = content;
                this.contentProvider.callbackForUnprocessedContent = callback;
                return;
            }
        }
        try {
            this.contentProvider.contentListener.onContent(content, (AsyncCallback)new JettyCallbackToEveritAsyncCallback(callback));
        }
        catch (Throwable e) {
            callback.failed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Response response, Throwable failure) {
        Consumer<Throwable> errorListener = null;
        Throwable throwable = failure;
        synchronized (throwable) {
            this.response = response;
            if (this.contentProvider == null) {
                this.errorBeforeHeaders = true;
            } else {
                this.contentProvider.error = failure;
                errorListener = this.contentProvider.errorListener;
            }
        }
        if (this.errorBeforeHeaders) {
            this.singleEmitter.onError(failure);
        } else if (errorListener != null) {
            errorListener.accept(failure);
        }
    }

    public void onHeaders(Response response) {
        Map<String, String> headers = JettyResponseListenerToEveritAsyncProvider.convertHeaderFieldToHeaderMap(response.getHeaders());
        Optional<Long> contentLength = this.resolveContentLength(headers);
        Optional<MediaType> contentType = this.resolveContentType(headers);
        this.response = response;
        this.contentProvider = new JettyToHttpResponseAsyncContentProvider(contentLength, contentType);
        HttpResponse httpResponse = HttpResponse.builder().status(response.getStatus()).headers(headers).body((AsyncContentProvider)this.contentProvider).build();
        this.singleEmitter.onSuccess((Object)httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(Response response) {
        Runnable completeListener = null;
        Object object = this.mutex;
        synchronized (object) {
            this.contentProvider.completed = true;
            if (this.contentProvider.completeListener != null) {
                completeListener = this.contentProvider.completeListener;
            }
        }
        if (completeListener != null) {
            completeListener.run();
        }
    }

    private Optional<Long> resolveContentLength(Map<String, String> headers) {
        String contentLengthHeader = headers.get("Content-Length");
        if (contentLengthHeader == null) {
            return Optional.empty();
        }
        return Optional.of(Long.parseLong(contentLengthHeader));
    }

    private Optional<MediaType> resolveContentType(Map<String, String> headers) {
        String contentTypeHeader = headers.get("Content-Type");
        if (contentTypeHeader == null) {
            return Optional.empty();
        }
        return Optional.of(MediaType.parse((String)contentTypeHeader));
    }

    private class JettyToHttpResponseAsyncContentProvider
    implements AsyncContentProvider {
        Callback callbackForUnprocessedContent = null;
        private AtomicBoolean closed = new AtomicBoolean();
        boolean completed = false;
        Runnable completeListener;
        private Optional<Long> contentLength;
        private AsyncContentListener contentListener;
        private Optional<MediaType> contentType;
        Throwable error = null;
        Consumer<Throwable> errorListener = null;
        ByteBuffer unprocessedContent = null;

        JettyToHttpResponseAsyncContentProvider(Optional<Long> contentLength, Optional<MediaType> contentType) {
            this.contentLength = contentLength;
            this.contentType = contentType;
        }

        public void close() {
            this.closed.set(true);
            if (this.completed) {
                return;
            }
            JettyResponseListenerToEveritAsyncProvider.this.response.abort((Throwable)new RuntimeException("Abort response"));
        }

        public Optional<Long> getContentLength() {
            return this.contentLength;
        }

        public Optional<MediaType> getContentType() {
            return this.contentType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<Throwable> getFailure() {
            Object object = JettyResponseListenerToEveritAsyncProvider.this.mutex;
            synchronized (object) {
                return Optional.ofNullable(this.error);
            }
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncContentProvider onContent(AsyncContentListener listener) {
            Callback tmpCallback;
            ByteBuffer tmpUnProcessedContent;
            Object object = JettyResponseListenerToEveritAsyncProvider.this.mutex;
            synchronized (object) {
                this.contentListener = listener;
                tmpUnProcessedContent = this.unprocessedContent;
                this.unprocessedContent = null;
                tmpCallback = this.callbackForUnprocessedContent;
                this.callbackForUnprocessedContent = null;
            }
            if (tmpUnProcessedContent != null) {
                listener.onContent(tmpUnProcessedContent, (AsyncCallback)new JettyCallbackToEveritAsyncCallback(tmpCallback));
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncContentProvider onError(Consumer<Throwable> action) {
            Throwable error = null;
            Object object = JettyResponseListenerToEveritAsyncProvider.this.mutex;
            synchronized (object) {
                this.errorListener = action;
                error = this.error;
            }
            if (error != null) {
                action.accept(error);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncContentProvider onSuccess(Runnable action) {
            boolean callAction;
            Object object = JettyResponseListenerToEveritAsyncProvider.this.mutex;
            synchronized (object) {
                this.completeListener = action;
                callAction = this.completed && this.error == null;
            }
            if (callAction) {
                action.run();
            }
            return this;
        }
    }

    public static class JettyCallbackToEveritAsyncCallback
    implements AsyncCallback {
        Callback callback;

        JettyCallbackToEveritAsyncCallback(Callback callback) {
            this.callback = callback;
        }

        public void failed(Throwable e) {
            this.callback.failed(e);
        }

        public void processed() {
            this.callback.succeeded();
        }
    }
}

