/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.jettyclient;

import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import java.net.HttpCookie;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.everit.http.client.HttpClient;
import org.everit.http.client.HttpRequest;
import org.everit.http.client.HttpResponse;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.jettyclient.internal.HttpRequestBodyAsyncContentProvider;
import org.everit.http.client.jettyclient.internal.JettyResponseListenerToEveritAsyncProvider;

public class JettyClientHttpClient
implements HttpClient {
    private ExecutorService executor = Executors.newCachedThreadPool();
    private final org.eclipse.jetty.client.HttpClient jettyClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callTwoFunctionsWithErrorHandling(ExceptionRunnable action1, ExceptionRunnable action2) {
        Throwable error = null;
        try {
            action1.run();
        }
        catch (Throwable e) {
            error = e;
        }
        finally {
            try {
                action2.run();
            }
            catch (Throwable e) {
                if (error != null) {
                    error.addSuppressed(e);
                } else {
                    error = e;
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                if (error instanceof Error) {
                    throw (Error)error;
                }
                throw new RuntimeException(error);
            }
        }
    }

    public JettyClientHttpClient(org.eclipse.jetty.client.HttpClient jettyClient) {
        if (!jettyClient.isStarted() && !jettyClient.isStarting()) {
            try {
                jettyClient.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.jettyClient = jettyClient;
    }

    public void close() {
        JettyClientHttpClient.callTwoFunctionsWithErrorHandling(() -> ((org.eclipse.jetty.client.HttpClient)this.jettyClient).stop(), this.executor::shutdown);
        try {
            this.jettyClient.stop();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            this.executor.shutdown();
        }
    }

    public Single<HttpResponse> send(HttpRequest request) {
        Request jettyRequest = this.jettyClient.newRequest(request.getUrl()).method(request.getMethod().toString());
        for (HttpCookie httpCookie : request.getCookies()) {
            jettyRequest.cookie(httpCookie);
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        if (request.getBody().isPresent()) {
            jettyRequest.content((ContentProvider)new HttpRequestBodyAsyncContentProvider((AsyncContentProvider)request.getBody().get(), arg_0 -> ((Request)jettyRequest).abort(arg_0), this.executor));
        }
        return Single.create(emitter -> {
            JettyResponseListenerToEveritAsyncProvider listener = new JettyResponseListenerToEveritAsyncProvider((SingleEmitter<HttpResponse>)emitter);
            emitter.setCancellable(() -> {
                if (!listener.isHeaderProcessedOrFailed()) {
                    jettyRequest.abort((Throwable)new RuntimeException("Aborting request"));
                }
            });
            jettyRequest.send((Response.CompleteListener)listener);
        });
    }

    private static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

