/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.everit.http.client.HttpMethod;
import org.everit.http.client.async.AsyncContentProvider;

public final class HttpRequest {
    private final Optional<AsyncContentProvider> body;
    private final Collection<HttpCookie> cookies;
    private final Map<String, String> headers;
    private final HttpMethod method;
    private final String url;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(HttpRequest httpRequest) {
        return new Builder(httpRequest);
    }

    private HttpRequest(Builder builder) {
        this.url = Objects.requireNonNull(builder.url);
        this.method = builder.method;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
        this.cookies = Collections.unmodifiableList(new ArrayList(builder.cookies));
        this.body = builder.body;
    }

    public Optional<AsyncContentProvider> getBody() {
        return this.body;
    }

    public Collection<HttpCookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public static final class Builder {
        private Optional<AsyncContentProvider> body = Optional.empty();
        private Collection<HttpCookie> cookies = Collections.emptyList();
        private Map<String, String> headers = Collections.emptyMap();
        private HttpMethod method;
        private String url;

        private Builder() {
        }

        private Builder(HttpRequest httpRequest) {
            this.url = httpRequest.url;
            this.method = httpRequest.method;
            this.headers = httpRequest.headers;
            this.cookies = httpRequest.cookies;
            this.body = httpRequest.body;
        }

        public Builder body(Optional<AsyncContentProvider> body) {
            this.body = Objects.requireNonNull(body);
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }

        public Builder cookies(Collection<HttpCookie> cookies) {
            this.cookies = Objects.requireNonNull(cookies);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = Objects.requireNonNull(headers);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = Objects.requireNonNull(method);
            return this;
        }

        public Builder url(String url) {
            this.url = Objects.requireNonNull(url);
            return this;
        }
    }
}

