/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    private static final Pattern PARAMETER;
    private static final int PARAMETER_MATCHER_GROUP_CHARSET = 3;
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final Pattern TYPE_SUBTYPE;
    private final Optional<String> charset;
    private final String mediaType;
    private final String subtype;
    private final String type;

    private static void checkOnlyOneCharsetDefined(String string, Optional<String> charset, String charsetParameter) {
        if (charset.isPresent() && !charsetParameter.equalsIgnoreCase(charset.get())) {
            throw new IllegalArgumentException("Multiple charsets defined: \"" + charset + "\" and: \"" + charsetParameter + "\" for: \"" + string + '\"');
        }
    }

    public static MediaType parse(String string) {
        Matcher typeSubtype = TYPE_SUBTYPE.matcher(string);
        if (!typeSubtype.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + string + '\"');
        }
        String type = typeSubtype.group(1).toLowerCase(Locale.US);
        String subtype = typeSubtype.group(2).toLowerCase(Locale.US);
        Optional<String> charset = Optional.empty();
        Matcher parameter = PARAMETER.matcher(string);
        int s = typeSubtype.end();
        while (s < string.length()) {
            parameter.region(s, string.length());
            if (!parameter.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: \"" + string.substring(s) + "\" for: \"" + string + '\"');
            }
            String name = parameter.group(1);
            if (name != null && "charset".equalsIgnoreCase(name)) {
                String token = parameter.group(2);
                String charsetParameter = token != null ? (token.startsWith("'") && token.endsWith("'") && token.length() > 2 ? token.substring(1, token.length() - 1) : token) : parameter.group(3);
                MediaType.checkOnlyOneCharsetDefined(string, charset, charsetParameter);
                charset = Optional.ofNullable(charsetParameter);
            }
            s = parameter.end();
        }
        return new MediaType(string, type, subtype, charset);
    }

    private MediaType(String mediaType, String type, String subtype, Optional<String> charset) {
        this.mediaType = mediaType;
        this.type = type;
        this.subtype = subtype;
        this.charset = charset;
    }

    public Optional<Charset> charset() {
        return this.charset(null);
    }

    public Optional<Charset> charset(Optional<Charset> defaultValue) {
        return this.charset.isPresent() ? Optional.of(Charset.forName(this.charset.get())) : defaultValue;
    }

    public boolean equals(Object other) {
        return other instanceof MediaType && ((MediaType)other).mediaType.equals(this.mediaType);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String subtype() {
        return this.subtype;
    }

    public String toString() {
        return this.mediaType;
    }

    public String type() {
        return this.type;
    }

    static {
        TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
        PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    }
}

