/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AbstractAsyncContentProvider;

public class ByteArrayAsyncContentProvider
extends AbstractAsyncContentProvider {
    private byte[] content;
    private AtomicBoolean contentProvided = new AtomicBoolean();
    private Optional<MediaType> contentType;

    public ByteArrayAsyncContentProvider(byte[] content, Optional<MediaType> contentType) {
        this.contentType = contentType;
        this.content = Objects.requireNonNull(content);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public Optional<Long> getContentLength() {
        return Optional.of(Long.valueOf(this.content.length));
    }

    @Override
    public Optional<MediaType> getContentType() {
        return this.contentType;
    }

    @Override
    protected void provideNextChunk(Consumer<ByteBuffer> callback) {
        if (this.contentProvided.getAndSet(true)) {
            this.handleSuccess();
            return;
        }
        callback.accept(ByteBuffer.wrap(this.content));
    }
}

