/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AbstractAsyncContentProvider;
import org.everit.http.client.async.AsyncCallback;
import org.everit.http.client.async.AsyncContentListener;
import org.everit.http.client.async.AsyncContentProvider;

public class ConcatenatedAsyncContentProvider
extends AbstractAsyncContentProvider {
    private final AsyncContentProvider[] contentProviders;
    private final Optional<MediaType> contentType;
    private AsyncCallback lastCallback = null;
    private ByteBuffer lastChunk = null;
    private Consumer<ByteBuffer> lastProvideCallback = null;
    private final Optional<Long> length;
    private final Object mutex = new Object();
    private int positionOfNextProvider = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callTwoFunctionsWithErrorHandling(Runnable action1, Runnable action2) {
        Throwable error = null;
        try {
            action1.run();
        }
        catch (Throwable e) {
            error = e;
        }
        finally {
            try {
                action2.run();
            }
            catch (Throwable e) {
                if (error != null) {
                    error.addSuppressed(e);
                } else {
                    error = e;
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                if (error instanceof Error) {
                    throw (Error)error;
                }
                throw new RuntimeException(error);
            }
        }
    }

    public ConcatenatedAsyncContentProvider(Optional<MediaType> contentType, AsyncContentProvider ... contentProviders) {
        this.contentType = contentType;
        this.contentProviders = (AsyncContentProvider[])contentProviders.clone();
        this.length = this.calculateLength();
        this.registerNextContentProvider();
    }

    private Optional<Long> calculateLength() {
        long sumLength = 0L;
        for (AsyncContentProvider contentProvider : this.contentProviders) {
            Optional<Long> contentLength = contentProvider.getContentLength();
            if (!contentLength.isPresent()) {
                return Optional.empty();
            }
            sumLength += contentLength.get().longValue();
        }
        return Optional.of(sumLength);
    }

    @Override
    protected void doClose() {
        Throwable error = null;
        for (AsyncContentProvider contentProvider : this.contentProviders) {
            try {
                contentProvider.close();
            }
            catch (Throwable e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Error) {
                throw (Error)error;
            }
            throw new RuntimeException(error);
        }
    }

    @Override
    public Optional<Long> getContentLength() {
        return this.length;
    }

    @Override
    public Optional<MediaType> getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void provideNextChunk(Consumer<ByteBuffer> provideCallback) {
        AsyncCallback tmpCallback;
        ByteBuffer tmpLastChunk;
        Object object = this.mutex;
        synchronized (object) {
            tmpLastChunk = this.lastChunk;
            if (tmpLastChunk == null) {
                this.lastProvideCallback = provideCallback;
                return;
            }
            this.lastChunk = null;
            tmpCallback = this.lastCallback;
            this.lastCallback = null;
        }
        ConcatenatedAsyncContentProvider.callTwoFunctionsWithErrorHandling(() -> provideCallback.accept(tmpLastChunk), tmpCallback::processed);
    }

    private void registerNextContentProvider() {
        if (this.positionOfNextProvider == this.contentProviders.length) {
            this.handleSuccess();
            return;
        }
        AsyncContentProvider contentProvider = this.contentProviders[this.positionOfNextProvider];
        ++this.positionOfNextProvider;
        contentProvider.onSuccess(this::registerNextContentProvider).onError(this::handleErrorFromInput).onContent(new AsyncContentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContent(ByteBuffer content, AsyncCallback callback) {
                Consumer tmpLastProvideCallback;
                Object object = ConcatenatedAsyncContentProvider.this.mutex;
                synchronized (object) {
                    tmpLastProvideCallback = ConcatenatedAsyncContentProvider.this.lastProvideCallback;
                    if (tmpLastProvideCallback == null) {
                        ConcatenatedAsyncContentProvider.this.lastCallback = callback;
                        ConcatenatedAsyncContentProvider.this.lastChunk = content;
                        return;
                    }
                    ConcatenatedAsyncContentProvider.this.lastProvideCallback = null;
                }
                ConcatenatedAsyncContentProvider.callTwoFunctionsWithErrorHandling(() -> tmpLastProvideCallback.accept(content), callback::processed);
            }
        });
    }
}

