/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.ByteArrayAsyncContentProvider;

public class FormUrlencodedAsyncContentProvider
extends ByteArrayAsyncContentProvider {
    private static byte[] convertParametersToByteArray(Map<String, Collection<String>> parameters) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (Map.Entry<String, Collection<String>> parameter : parameters.entrySet()) {
            Collection<String> values = parameter.getValue();
            try {
                String key = parameter.getKey();
                if (values == null || values.isEmpty()) {
                    bout.write((URLEncoder.encode(key, "UTF-8") + '=').getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                for (String value : values) {
                    bout.write((URLEncoder.encode(key, "UTF-8") + '=' + URLEncoder.encode(value, "UTF-8")).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return bout.toByteArray();
    }

    public FormUrlencodedAsyncContentProvider(Map<String, Collection<String>> parameters) {
        super(FormUrlencodedAsyncContentProvider.convertParametersToByteArray(parameters), Optional.of(MediaType.parse("application/x-www-form-urlencoded;charset=UTF-8")));
    }
}

