/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.everit.http.client.async.AsyncContentProvider;

public final class AsyncContentUtil {
    public static Single<byte[]> readAllBytes(AsyncContentProvider asyncContentProvider) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        return Single.create(subscriber -> asyncContentProvider.onContent((buffer, callback) -> {
            byte[] b = new byte[buffer.remaining()];
            buffer.get(b);
            try {
                bout.write(b);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            callback.processed();
        }).onSuccess(() -> subscriber.onSuccess((Object)bout.toByteArray())).onError(arg_0 -> ((SingleEmitter)subscriber).onError(arg_0)));
    }

    public static Single<String> readString(AsyncContentProvider asyncContentProvider, Charset charset) {
        return AsyncContentUtil.readAllBytes(asyncContentProvider).map(content -> new String((byte[])content, charset));
    }

    private AsyncContentUtil() {
    }
}

