/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AbstractAsyncContentProvider;

public class InputStreamAsyncContentProvider
extends AbstractAsyncContentProvider {
    private final byte[] buffer;
    private final Optional<Long> contentLength;
    private final Optional<MediaType> contentType;
    private final InputStream in;

    public InputStreamAsyncContentProvider(InputStream in, Optional<Long> contentLength, Optional<MediaType> contentType, int bufferSize) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(contentLength);
        Objects.requireNonNull(contentType);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        this.in = in;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.buffer = new byte[bufferSize];
    }

    @Override
    protected void doClose() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Optional<Long> getContentLength() {
        return this.contentLength;
    }

    @Override
    public Optional<MediaType> getContentType() {
        return this.contentType;
    }

    @Override
    protected void provideNextChunk(Consumer<ByteBuffer> callback) {
        Integer read = null;
        try {
            read = this.in.read(this.buffer);
        }
        catch (IOException e) {
            this.handleErrorFromInput(e);
            return;
        }
        if (read != null) {
            if (read >= 0) {
                callback.accept(ByteBuffer.wrap(Arrays.copyOf(this.buffer, (int)read)));
            } else {
                this.handleSuccess();
            }
        }
    }
}

