/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Optional;
import java.util.function.Consumer;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AbstractAsyncContentProvider;

public class ReadableByteChannelAsyncContentProvider
extends AbstractAsyncContentProvider {
    private ByteBuffer buffer;
    private final ReadableByteChannel byteChannel;
    private Optional<Long> contentLength;
    private Optional<MediaType> contentType;

    public ReadableByteChannelAsyncContentProvider(ReadableByteChannel byteChannel, Optional<Long> contentLength, Optional<MediaType> contentType, int bufferSize) {
        this.byteChannel = byteChannel;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    protected void doClose() {
        try {
            this.byteChannel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Optional<Long> getContentLength() {
        return this.contentLength;
    }

    @Override
    public Optional<MediaType> getContentType() {
        return this.contentType;
    }

    @Override
    protected void provideNextChunk(Consumer<ByteBuffer> callback) {
        Integer read = null;
        try {
            this.buffer.clear();
            read = this.byteChannel.read(this.buffer);
        }
        catch (Throwable e) {
            this.handleErrorFromInput(e);
            return;
        }
        if (read != null) {
            if (read <= 0) {
                this.handleSuccess();
            } else {
                this.buffer.flip();
                callback.accept(this.buffer);
            }
        }
    }
}

