/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.restclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.everit.http.client.HttpClient;
import org.everit.http.client.HttpRequest;
import org.everit.http.client.HttpResponse;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.async.AsyncContentUtil;
import org.everit.http.client.async.AutoCloseAsyncContentProvider;
import org.everit.http.client.async.ByteArrayAsyncContentProvider;
import org.everit.http.restclient.RestException;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;

public final class RestCallUtil {
    public static final DateTimeFormatter DATETIMEFORMATTER_OFFSETDATETIME_WITH_OPTIONAL_MILLISECS = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendOffset("+HHmm", "Z").optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    private static final int HTTP_LOWEST_ERROR_CODE = 400;
    private static final ObjectMapper OBJECT_MAPPER = RestCallUtil.createObjectMapper();

    public static Completable callEndpoint(HttpClient httpClient, RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer) {
        Single<HttpResponse> single = RestCallUtil.callEndpointAndHandleErrors(httpClient, restRequest, requestEnhancer);
        return Single.create(emitter -> {
            Disposable disposable = single.subscribe(httpResponse -> {
                try {
                    emitter.onSuccess(httpResponse);
                }
                finally {
                    httpResponse.close();
                }
            }, error -> emitter.onError(error));
            emitter.setCancellable(() -> disposable.dispose());
        }).ignoreElement();
    }

    public static <T> Single<T> callEndpoint(HttpClient httpClient, RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer, TypeReference<T> returnType) {
        Single<HttpResponse> response = RestCallUtil.callEndpointAndHandleErrors(httpClient, restRequest, requestEnhancer);
        return response.flatMap(httpResponse -> AsyncContentUtil.readString((AsyncContentProvider)new AutoCloseAsyncContentProvider(httpResponse.getBody(), new Closeable[]{httpResponse}), (Charset)StandardCharsets.UTF_8)).map(stringResponse -> OBJECT_MAPPER.readValue(stringResponse, returnType));
    }

    private static Single<HttpResponse> callEndpointAndHandleErrors(HttpClient httpClient, RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer) {
        return RestCallUtil.enhanceRequest(restRequest, requestEnhancer).flatMap(enhancedRestRequest -> RestCallUtil.callHttpEndpointAndHandleErrorsWithEnhancedRequest(httpClient, enhancedRestRequest));
    }

    private static Single<HttpResponse> callHttpEndpointAndHandleErrorsWithEnhancedRequest(HttpClient httpClient, RestRequest enhancedRestRequest) {
        String url = enhancedRestRequest.buildURI();
        HttpRequest request = HttpRequest.builder().url(url).method(enhancedRestRequest.getMethod()).headers(enhancedRestRequest.getHeaders()).body(RestCallUtil.createHttpBody(enhancedRestRequest.getRequestBody())).build();
        Single response = httpClient.send(request).flatMap(httpResponse -> {
            if (httpResponse.getStatus() >= 400) {
                return AsyncContentUtil.readString((AsyncContentProvider)new AutoCloseAsyncContentProvider(httpResponse.getBody(), new Closeable[]{httpResponse}), (Charset)StandardCharsets.UTF_8).map(content -> {
                    throw new RestException("Error sending request: " + request.getUrl(), httpResponse.getStatus(), Optional.ofNullable("".equals(content) ? null : content));
                });
            }
            return Single.just((Object)httpResponse);
        });
        return response;
    }

    private static Optional<AsyncContentProvider> createHttpBody(Optional<?> requestBodyOpt) {
        String json;
        if (!requestBodyOpt.isPresent()) {
            return Optional.empty();
        }
        Object requestBody = requestBodyOpt.get();
        if (requestBody instanceof AsyncContentProvider) {
            return Optional.of((AsyncContentProvider)requestBody);
        }
        try {
            json = OBJECT_MAPPER.writeValueAsString(requestBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        byte[] jsonByteArray = json.getBytes(StandardCharsets.UTF_8);
        return Optional.of(new ByteArrayAsyncContentProvider(jsonByteArray, Optional.of(MediaType.parse((String)"application/json"))));
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer());
        objectMapper.registerModule((Module)javaTimeModule);
        return objectMapper;
    }

    private static Single<RestRequest> enhanceRequest(RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer) {
        if (requestEnhancer.isPresent()) {
            return requestEnhancer.get().enhanceRestRequest(restRequest);
        }
        return Single.just((Object)restRequest);
    }

    public static Collection<String> objectCollectionToStringCollection(Collection<?> collection) {
        ArrayList<String> result = new ArrayList<String>(collection.size());
        for (Object obj : collection) {
            result.add(String.valueOf(obj));
        }
        return result;
    }

    private RestCallUtil() {
    }

    private static class OffsetDateTimeDeserializer
    extends InstantDeserializer<OffsetDateTime> {
        private static final long serialVersionUID = 4935425608165819930L;

        OffsetDateTimeDeserializer() {
            super(OffsetDateTime.class, DATETIMEFORMATTER_OFFSETDATETIME_WITH_OPTIONAL_MILLISECS, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true);
        }
    }
}

