/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.restclient;

import java.util.Optional;

public class RestException
extends RuntimeException {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final long serialVersionUID = 3006142336269779329L;
    private final int httpCode;
    private final String responseBody;

    private static String createDetailedMessage(String message, String requestUrl, int httpCode, Optional<String> responseBody) {
        return message + LINE_SEPARATOR + "REQUEST URL: " + requestUrl + LINE_SEPARATOR + "STATUS CODE: " + httpCode + LINE_SEPARATOR + "RESPONSE BODY: " + LINE_SEPARATOR + responseBody;
    }

    public RestException(String message, int httpCode, Optional<String> responseBody) {
        super(message);
        this.httpCode = httpCode;
        this.responseBody = responseBody.isPresent() ? responseBody.get() : null;
    }

    public RestException(String message, String requestUrl, int httpCode, Optional<String> responseBody) {
        super(RestException.createDetailedMessage(message, requestUrl, httpCode, responseBody));
        this.httpCode = httpCode;
        this.responseBody = responseBody.isPresent() ? responseBody.get() : null;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public Optional<String> getResponseBody() {
        return Optional.ofNullable(this.responseBody);
    }
}

