/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.restclient;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.everit.http.client.HttpClient;
import org.everit.http.client.HttpRequest;
import org.everit.http.client.HttpResponse;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.async.AsyncContentUtil;
import org.everit.http.client.async.AutoCloseAsyncContentProvider;
import org.everit.http.client.async.ByteArrayAsyncContentProvider;
import org.everit.http.restclient.JSONObjectMapper;
import org.everit.http.restclient.RestException;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class RestClient {
    private static final int HTTP_LOWEST_ERROR_CODE = 400;
    private HttpClient httpClient;
    private final JSONObjectMapper objectMapper;

    public RestClient(HttpClient httpClient, JSONObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public Completable callEndpoint(RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer) {
        Single<HttpResponse> single = this.callEndpointAndHandleErrors(restRequest, requestEnhancer);
        return Single.create(emitter -> {
            Disposable disposable = single.subscribe(httpResponse -> {
                try {
                    emitter.onSuccess(httpResponse);
                }
                finally {
                    httpResponse.close();
                }
            }, error -> emitter.onError(error));
            emitter.setCancellable(() -> disposable.dispose());
        }).ignoreElement();
    }

    public <T> Single<T> callEndpoint(RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer, TypeReference<T> returnType) {
        Single<HttpResponse> response = this.callEndpointAndHandleErrors(restRequest, requestEnhancer);
        return response.flatMap(httpResponse -> AsyncContentUtil.readString((AsyncContentProvider)new AutoCloseAsyncContentProvider(httpResponse.getBody(), new Closeable[]{httpResponse}), (Charset)StandardCharsets.UTF_8)).map(stringResponse -> this.objectMapper.fromJSON((String)stringResponse, returnType));
    }

    private Single<HttpResponse> callEndpointAndHandleErrors(RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer) {
        return this.enhanceRequest(restRequest, requestEnhancer).flatMap(enhancedRestRequest -> this.callHttpEndpointAndHandleErrorsWithEnhancedRequest((RestRequest)enhancedRestRequest));
    }

    private Single<HttpResponse> callHttpEndpointAndHandleErrorsWithEnhancedRequest(RestRequest enhancedRestRequest) {
        String url = enhancedRestRequest.buildURI();
        HttpRequest request = HttpRequest.builder().url(url).method(enhancedRestRequest.getMethod()).headers(enhancedRestRequest.getHeaders()).body(this.createHttpBody(enhancedRestRequest.getRequestBody())).build();
        Single response = this.httpClient.send(request).flatMap(httpResponse -> {
            if (httpResponse.getStatus() >= 400) {
                return AsyncContentUtil.readString((AsyncContentProvider)new AutoCloseAsyncContentProvider(httpResponse.getBody(), new Closeable[]{httpResponse}), (Charset)StandardCharsets.UTF_8).map(content -> {
                    throw new RestException("Error sending request!", request.getUrl(), httpResponse.getStatus(), Optional.ofNullable("".equals(content) ? null : content));
                });
            }
            return Single.just((Object)httpResponse);
        });
        return response;
    }

    private Optional<AsyncContentProvider> createHttpBody(Optional<?> requestBodyOpt) {
        if (!requestBodyOpt.isPresent()) {
            return Optional.empty();
        }
        Object requestBody = requestBodyOpt.get();
        if (requestBody instanceof AsyncContentProvider) {
            return Optional.of((AsyncContentProvider)requestBody);
        }
        String json = this.objectMapper.toJSON(requestBody);
        byte[] jsonByteArray = json.getBytes(StandardCharsets.UTF_8);
        return Optional.of(new ByteArrayAsyncContentProvider(jsonByteArray, Optional.of(MediaType.parse((String)"application/json"))));
    }

    private Single<RestRequest> enhanceRequest(RestRequest restRequest, Optional<RestRequestEnhancer> requestEnhancer) {
        if (requestEnhancer.isPresent()) {
            return requestEnhancer.get().enhanceRestRequest(restRequest);
        }
        return Single.just((Object)restRequest);
    }

    public JSONObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

