/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.restclient;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.everit.http.client.HttpMethod;

public final class RestRequest {
    private final String basePath;
    private final Map<String, String> headers;
    private final HttpMethod method;
    private final String path;
    private final Map<String, String> pathParams;
    private final Map<String, Collection<String>> queryParams;
    private final Optional<?> requestBody;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(RestRequest restRequest) {
        return new Builder(restRequest);
    }

    private RestRequest(Builder builder) {
        this.basePath = builder.basePath;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
        this.method = builder.method;
        this.path = builder.path;
        this.pathParams = Collections.unmodifiableMap(new HashMap(builder.pathParams));
        this.queryParams = Collections.unmodifiableMap(new HashMap(builder.queryParams));
        this.requestBody = builder.requestBody;
    }

    public String buildPathWithPathParams() {
        String pathWithPathParams = this.path != null ? this.path : "";
        for (Map.Entry<String, String> pathParam : this.pathParams.entrySet()) {
            pathWithPathParams = pathWithPathParams.replace('{' + pathParam.getKey() + '}', pathParam.getValue());
        }
        return pathWithPathParams;
    }

    public String buildURI() {
        String basePath = this.basePath != null ? this.basePath : "";
        StringBuilder url = new StringBuilder(basePath);
        String pathWithPathParams = this.buildPathWithPathParams();
        if (pathWithPathParams.length() > 0 && !pathWithPathParams.startsWith("/") && !basePath.endsWith("/")) {
            url.append('/');
        }
        url.append(pathWithPathParams);
        int separatorChar = url.toString().contains("?") ? 38 : 63;
        for (Map.Entry<String, Collection<String>> queryParam : this.queryParams.entrySet()) {
            for (String paramValue : queryParam.getValue()) {
                url.append((char)separatorChar);
                if (separatorChar != 38) {
                    separatorChar = 38;
                }
                try {
                    url.append(URLEncoder.encode(queryParam.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(paramValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return url.toString();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public Map<String, Collection<String>> getQueryParams() {
        return this.queryParams;
    }

    public Optional<?> getRequestBody() {
        return this.requestBody;
    }

    public static final class Builder {
        private String basePath;
        private Map<String, String> headers = Collections.emptyMap();
        private HttpMethod method = HttpMethod.GET;
        private String path;
        private Map<String, String> pathParams = Collections.emptyMap();
        private Map<String, Collection<String>> queryParams = Collections.emptyMap();
        private Optional<?> requestBody = Optional.empty();

        private Builder() {
        }

        private Builder(RestRequest restRequest) {
            this.basePath = restRequest.basePath;
            this.headers = restRequest.headers;
            this.method = restRequest.method;
            this.path = restRequest.path;
            this.pathParams = restRequest.pathParams;
            this.queryParams = restRequest.queryParams;
            this.requestBody = restRequest.requestBody;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public RestRequest build() {
            return new RestRequest(this);
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder pathParams(Map<String, String> pathParams) {
            this.pathParams = pathParams;
            return this;
        }

        public Builder queryParams(Map<String, Collection<String>> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder requestBody(Optional<?> requestBody) {
            this.requestBody = requestBody;
            return this;
        }
    }
}

