/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.restclient;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.everit.http.client.HttpMethod;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.async.AsyncContentUtil;

public class RestException
extends RuntimeException {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final long serialVersionUID = 3006142336269779329L;
    private final HttpMethod httpMethod;
    private final String originalMessage;
    private final String requestUrl;
    private final String responseBody;
    private final int status;

    private static String createDetailedMessage(String message, HttpMethod httpMethod, String requestUrl, Optional<AsyncContentProvider> requestBody, int status, Optional<String> responseBody) {
        return message + LINE_SEPARATOR + "HTTP METHOD: " + httpMethod + LINE_SEPARATOR + "REQUEST URL: " + requestUrl + LINE_SEPARATOR + "REQUEST BODY: " + LINE_SEPARATOR + (requestBody.isPresent() ? (String)AsyncContentUtil.readString((AsyncContentProvider)requestBody.get(), (Charset)StandardCharsets.UTF_8).blockingGet() : "[-NO-REQUEST-BODY-AVAILABLE-]") + LINE_SEPARATOR + "STATUS CODE: " + status + LINE_SEPARATOR + "RESPONSE BODY: " + LINE_SEPARATOR + (responseBody.isPresent() ? responseBody.get() : "[-NO-RESPONSE-BODY-AVAILABLE-]");
    }

    public RestException(String message, HttpMethod httpMethod, String requestUrl, Optional<AsyncContentProvider> requestBody, int status, Optional<String> responseBody, Throwable cause) {
        super(RestException.createDetailedMessage(message, httpMethod, requestUrl, requestBody, status, responseBody), cause);
        this.originalMessage = message;
        this.httpMethod = httpMethod;
        this.requestUrl = requestUrl;
        this.status = status;
        this.responseBody = responseBody.isPresent() ? responseBody.get() : null;
    }

    public RestException(String message, int status, Optional<String> responseBody) {
        this(message, status, responseBody, null);
    }

    public RestException(String message, int status, Optional<String> responseBody, Throwable cause) {
        this(message, null, null, Optional.empty(), status, responseBody, cause);
    }

    public RestException(String message, String requestUrl, int status, Optional<String> responseBody) {
        this(message, null, requestUrl, Optional.empty(), status, responseBody, null);
    }

    @Deprecated
    public int getHttpCode() {
        return this.getStatus();
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public Optional<String> getResponseBody() {
        return Optional.ofNullable(this.responseBody);
    }

    public int getStatus() {
        return this.status;
    }
}

