/*
 * Decompiled with CFR 0.152.
 */
package org.everit.jdk.javaagent.shutdown;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ShutdownAgent {
    public static final String ARG_EXIT_CODE = "exitcode";
    public static final String ARG_EXIT_TIMEOUT = "timeout";
    public static final String ARG_HALT_CODE = "haltcode";
    public static final int DEFAULT_EXIT_CODE = 0;
    public static final long DEFAULT_EXIT_TIMEOUT = 0L;
    public static final int DEFAULT_HALT_CODE = 1;

    public static void agentmain(String agentArgs) {
        Map<String, String> args = ShutdownAgent.splitAgentArgs(agentArgs);
        final long timeout = ShutdownAgent.resolveLongArg(ARG_EXIT_TIMEOUT, 0L, args);
        final int exitCode = (int)ShutdownAgent.resolveLongArg(ARG_EXIT_CODE, 0L, args);
        final int haltCode = (int)ShutdownAgent.resolveLongArg(ARG_HALT_CODE, 1L, args);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runtime.getRuntime().exit(exitCode);
            }
        }).start();
        if (timeout > 0L) {
            Thread haltThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    long startTime;
                    long endTime = startTime = System.currentTimeMillis();
                    while (endTime - startTime < timeout) {
                        try {
                            Thread.sleep(timeout);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                        if ((endTime = System.currentTimeMillis()) - startTime < timeout) continue;
                        Runtime.getRuntime().halt(haltCode);
                    }
                }
            });
            haltThread.setDaemon(true);
            haltThread.start();
        }
    }

    private static long resolveLongArg(String argName, long defaultValue, Map<String, String> args) {
        String argString = args.get(argName);
        if (argString == null) {
            return defaultValue;
        }
        return Long.parseLong(argString);
    }

    private static Map<String, String> splitAgentArgs(String agentArgs) {
        if (agentArgs == null) {
            return Collections.emptyMap();
        }
        String[] splitted = agentArgs.split(",");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String argString : splitted) {
            String[] argParts = argString.split("=");
            String key = argParts[0];
            if (argParts.length == 1) {
                result.put(key, null);
            }
            StringBuilder value = new StringBuilder();
            for (int i = 1; i < argParts.length; ++i) {
                value.append(argParts[i]);
            }
            result.put(key, value.toString());
        }
        return result;
    }

    private ShutdownAgent() {
    }
}

