/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.hsqldb.ecm.internal;

import java.util.Hashtable;
import javax.sql.DataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.hsqldb.ecm.internal.AbstractHsqlDatasourceComponent;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCDataSource;

@Component(componentId="org.everit.persistence.hsqldb.ecm.HsqlDataSource", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit HSQLDB DataSource", description="Configurable component that instantiates HSQLDB DataSource and registers it as an OSGi service based on DataSource interface.")
@ManualServices(value={@ManualService(value={DataSource.class, JDBCDataSource.class})})
@ExtendComponent
public class HsqlDataSourceComponent
extends AbstractHsqlDatasourceComponent {
    @Activate
    public void activate(ComponentContext<HsqlDataSourceComponent> componentContext) {
        JDBCDataSource jdbcDataSource = null;
        jdbcDataSource = new JDBCDataSource();
        this.updatePropertiesAToD((JDBCCommonDataSource)jdbcDataSource);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(new String[]{DataSource.class.getName(), JDBCDataSource.class.getName()}, (Object)jdbcDataSource, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

