/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.hsqldb.ecm.internal;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.XADataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.hsqldb.ecm.internal.AbstractHsqlDatasourceComponent;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.pool.JDBCXADataSource;

@Component(componentId="org.everit.persistence.hsqldb.ecm.HsqlXADataSource", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit HSQLDB XADataSource", description="Configurable component that instantiates HSQLDB XADataSource and registers it as an OSGi service based on XADataSource interface.")
@ManualServices(value={@ManualService(value={XADataSource.class, JDBCXADataSource.class})})
@ExtendComponent
public class HsqlXADataSourceComponent
extends AbstractHsqlDatasourceComponent {
    @Activate
    public void activate(ComponentContext<HsqlXADataSourceComponent> componentContext) {
        JDBCXADataSource jdbcXADataSource = null;
        try {
            jdbcXADataSource = new JDBCXADataSource();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.updatePropertiesAToD((JDBCCommonDataSource)jdbcXADataSource);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(new String[]{XADataSource.class.getName(), JDBCXADataSource.class.getName()}, (Object)jdbcXADataSource, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

