/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.jdbc.dsf.ecm.internal;

import aQute.bnd.annotation.headers.ProvideCapability;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.ThreeStateBoolean;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttribute;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttributes;
import org.everit.osgi.ecm.annotation.attribute.PasswordAttribute;
import org.everit.osgi.ecm.annotation.attribute.PasswordAttributes;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.component.ServiceHolder;
import org.everit.persistence.jdbc.dsf.ecm.internal.DSFUtil;
import org.everit.persistence.jdbc.dsf.ecm.internal.XADataSourceComponent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.log.LogService;

@Component(componentId="org.everit.persistence.jdbc.dsf.ecm.DataSource", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit DataSource", description="Using a DataSourceFactory, this component registers a new DataSource service.")
@StringAttributes(value={@StringAttribute(attributeId="url", priority=2.0f, label="Jdbc URL", description="The Jdbc Url that will be used to connect to the database."), @StringAttribute(attributeId="networkProtocol", priority=3.0f, defaultValue={""}, label="Network protocol", description="The network protocol of the JDBC channel. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="serverName", priority=4.0f, defaultValue={""}, label="Server name", description="The name or IP address of the database server. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="portNumber", priority=5.0f, defaultValue={""}, label="Port", description="The port where the database server listens on. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="databaseName", priority=6.0f, defaultValue={""}, label="Database name", description="Name of the database on the server. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="user", priority=7.0f, defaultValue={""}, label="User name", description="The name of the user that is used during database authentication."), @StringAttribute(attributeId="dataSourceName", priority=9.0f, defaultValue={""}, label="DataSource name", description="Name of the data source."), @StringAttribute(attributeId="description", priority=10.0f, defaultValue={""}, label="DataSource description", description="Description of the data source."), @StringAttribute(attributeId="roleName", priority=17.0f, defaultValue={""}, label="Role name", description="The name of the role that the datasource will connect with."), @StringAttribute(attributeId="customProperties", defaultValue={""}, multiple=ThreeStateBoolean.TRUE, priority=18.0f, label="Custom properties", description="An array of custom properties that can be specified for DataSourceFactory calls. The syntax is 'name=value' where the name cannot contain '=' character. There are no escaping rules like in properties files, just type the text that you need. Do not use spaces before and after the '=' character!"), @StringAttribute(attributeId="service.description", defaultValue={""}, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@PasswordAttributes(value={@PasswordAttribute(attributeId="password", defaultValue={""}, priority=8.0f, label="Password", description="Password that is used during database authentication.")})
@IntegerAttributes(value={@IntegerAttribute(attributeId="loginTimeout", defaultValue={0}, priority=19.0f, label="Login timeout", description="Sets the maximum time in seconds that this data source will wait while attempting to connect to a database.  A value of zero specifies that the timeout is the default system timeout if there is one; otherwise, it specifies that there is no timeout.")})
@ManualService(value={DataSource.class})
@ProvideCapability(ns="org.everit.osgi.ecm.component", value="class=${@class}")
public class DataSourceComponent {
    protected DataSourceFactory dataSourceFactory;
    protected Map<String, Object> dataSourceFactoryProperties;
    protected LogService logService;
    private ServiceRegistration<DataSource> serviceRegistration;

    @Activate
    public void activate(ComponentContext<XADataSourceComponent> componentContext) {
        Map componentProperties = componentContext.getProperties();
        Properties jdbcProps = DSFUtil.collectDataSourceProperties(componentProperties);
        try {
            DataSource dataSource = this.dataSourceFactory.createDataSource(jdbcProps);
            Hashtable<String, Object> serviceProperties = DSFUtil.collectDataSourceServiceProperties(componentProperties, this.dataSourceFactoryProperties);
            DSFUtil.initializeDataSource(dataSource, componentProperties, this.logService);
            this.serviceRegistration = componentContext.registerService(DataSource.class, (Object)dataSource, serviceProperties);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error during creating DataSource with properties: " + componentProperties.toString(), e);
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @ServiceRef(defaultValue={""}, attributePriority=1.0f, label="DataSourceFactory OSGi service filter", description="Filter expression of the DataSourceFactory OSGi service.")
    public void setDataSourceFactory(ServiceHolder<DataSourceFactory> dataSourceFactory) {
        this.dataSourceFactory = (DataSourceFactory)dataSourceFactory.getService();
        this.dataSourceFactoryProperties = dataSourceFactory.getAttributes();
    }

    @ServiceRef(defaultValue={""}, attributePriority=20.0f, label="LogService OSGi service filter", description="Filter expression of the DataSourceFactory OSGi service.")
    public void setLogService(LogService logService) {
        this.logService = logService;
    }
}

