/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.jdbc.dsf.ecm.internal;

import aQute.bnd.annotation.headers.ProvideCapability;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.XADataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.persistence.jdbc.dsf.ecm.internal.DSFUtil;
import org.everit.persistence.jdbc.dsf.ecm.internal.DataSourceComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.persistence.jdbc.dsf.ecm.XADataSource", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit XADataSource", description="Using a DataSourceFactory, this component registers a new XADataSource service.")
@StringAttributes(value={@StringAttribute(attributeId="maxIdleTime", priority=11.0f, defaultValue={""}, label="Max. idle time"), @StringAttribute(attributeId="maxStatements", priority=12.0f, defaultValue={""}, label="Max. statements"), @StringAttribute(attributeId="propertyCycle", priority=13.0f, defaultValue={""}, label="Property lifecycle"), @StringAttribute(attributeId="initialPoolSize", priority=14.0f, defaultValue={""}, label="Initial pool size"), @StringAttribute(attributeId="minPoolSize", priority=15.0f, defaultValue={""}, label="Min. pool size"), @StringAttribute(attributeId="maxPoolSize", priority=16.0f, defaultValue={""}, label="Max. pool size")})
@ManualService(value={XADataSource.class})
@ProvideCapability(ns="org.everit.osgi.ecm.component", value="class=${@class}")
public class XADataSourceComponent
extends DataSourceComponent {
    private ServiceRegistration<XADataSource> serviceRegistration;

    @Override
    @Activate
    public void activate(ComponentContext<XADataSourceComponent> componentContext) {
        Map componentProperties = componentContext.getProperties();
        Properties jdbcProps = DSFUtil.collectDataSourceProperties(componentProperties);
        try {
            XADataSource xaDataSource = this.dataSourceFactory.createXADataSource(jdbcProps);
            Hashtable<String, Object> serviceProperties = DSFUtil.collectDataSourceServiceProperties(componentProperties, this.dataSourceFactoryProperties);
            DSFUtil.initializeDataSource(xaDataSource, componentProperties, this.logService);
            this.serviceRegistration = componentContext.registerService(XADataSource.class, (Object)xaDataSource, serviceProperties);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error during creating XADataSource with properties: " + componentProperties.toString(), e);
        }
    }

    @Override
    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

