/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.jdbc.dsf.ecm.internal;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.CommonDataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.ThreeStateBoolean;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttribute;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttributes;
import org.everit.osgi.ecm.annotation.attribute.PasswordAttribute;
import org.everit.osgi.ecm.annotation.attribute.PasswordAttributes;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.persistence.jdbc.dsf.ecm.internal.DSFUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.log.LogService;

@StringAttributes(value={@StringAttribute(attributeId="url", optional=true, priority=2.0f, label="Jdbc URL", description="The Jdbc Url that will be used to connect to the database."), @StringAttribute(attributeId="networkProtocol", optional=true, priority=3.0f, label="Network protocol", description="The network protocol of the JDBC channel. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="serverName", optional=true, priority=4.0f, label="Server name", description="The name or IP address of the database server. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="portNumber", optional=true, priority=5.0f, label="Port", description="The port where the database server listens on. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="databaseName", optional=true, priority=6.0f, label="Database name", description="Name of the database on the server. When Jdbc URL is provided, normally this setting is ignored."), @StringAttribute(attributeId="user", optional=true, priority=7.0f, label="User name", description="The name of the user that is used during database authentication."), @StringAttribute(attributeId="dataSourceName", optional=true, priority=9.0f, label="DataSource name", description="Name of the data source."), @StringAttribute(attributeId="description", optional=true, priority=10.0f, label="DataSource description", description="Description of the data source."), @StringAttribute(attributeId="roleName", optional=true, priority=17.0f, label="Role name", description="The name of the role that the datasource will connect with."), @StringAttribute(attributeId="customProperties", optional=true, multiple=ThreeStateBoolean.TRUE, priority=18.0f, label="Custom properties", description="An array of custom properties that can be specified for DataSourceFactory calls. The syntax is 'name=value' where the name cannot contain '=' character. There are no escaping rules like in properties files, just type the text that you need. Do not use spaces before and after the '=' character!"), @StringAttribute(attributeId="service.description", defaultValue={"Created via DataSourceFactory"}, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@PasswordAttributes(value={@PasswordAttribute(attributeId="password", optional=true, priority=8.0f, label="Password", description="Password that is used during database authentication.")})
@IntegerAttributes(value={@IntegerAttribute(attributeId="loginTimeout", optional=true, priority=19.0f, label="Login timeout", description="Sets the maximum time in seconds that this data source will wait while attempting to connect to a database.  A value of zero specifies that the timeout is the default system timeout if there is one; otherwise, it specifies that there is no timeout.")})
public abstract class AbstractDataSourceComponent<C extends CommonDataSource> {
    public static final int ATTR_P_CUSTOM_PROPERTIES = 18;
    public static final int ATTR_P_DATA_SOURCE_FACTORY = 1;
    public static final int ATTR_P_JDBC_DATABASE_NAME = 6;
    public static final int ATTR_P_JDBC_DATASOURCE_NAME = 9;
    public static final int ATTR_P_JDBC_DESCRIPTION = 10;
    public static final int ATTR_P_JDBC_NETWORK_PROTOCOL = 3;
    public static final int ATTR_P_JDBC_PASSWORD = 8;
    public static final int ATTR_P_JDBC_PORT_NUMBER = 5;
    public static final int ATTR_P_JDBC_ROLE_NAME = 17;
    public static final int ATTR_P_JDBC_SERVER_NAME = 4;
    public static final int ATTR_P_JDBC_URL = 2;
    public static final int ATTR_P_JDBC_USER = 7;
    public static final int ATTR_P_LOG_SERVICE = 20;
    public static final int ATTR_P_LOGIN_TIMEOUT = 19;
    protected DataSourceFactory dataSourceFactory;
    protected LogService logService;
    private ServiceRegistration<C> serviceRegistration;

    @Activate
    public void activate(ComponentContext<C> componentContext) {
        Map componentProperties = componentContext.getProperties();
        Hashtable serviceProperties = new Hashtable(componentProperties);
        Properties jdbcProps = DSFUtil.collectDataSourceProperties(componentProperties);
        try {
            C dataSource = this.createServiceObject(jdbcProps);
            DSFUtil.initializeDataSource(dataSource, componentProperties, this.logService);
            this.serviceRegistration = componentContext.registerService(this.getServiceType(), dataSource, serviceProperties);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error during creating " + this.getServiceType() + " with properties: " + componentProperties.toString(), e);
        }
    }

    protected abstract C createServiceObject(Properties var1) throws SQLException;

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    protected abstract Class<C> getServiceType();

    @ServiceRef(defaultValue={""}, attributePriority=1.0f, label="DataSourceFactory OSGi service filter", description="Filter expression of the DataSourceFactory OSGi service.")
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    @ServiceRef(defaultValue={""}, attributePriority=20.0f, label="LogService OSGi service filter", description="Filter expression of the DataSourceFactory OSGi service.")
    public void setLogService(LogService logService) {
        this.logService = logService;
    }
}

