/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.jdbc.dsf.ecm.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.CommonDataSource;
import org.everit.osgi.ecm.component.PasswordHolder;
import org.osgi.service.log.LogService;

public final class DSFUtil {
    public static Properties collectDataSourceProperties(Map<String, Object> componentProperties) {
        Properties jdbcProps = new Properties();
        DSFUtil.putVisibleProperties(componentProperties, jdbcProps);
        Object passwordObj = componentProperties.get("password");
        if (passwordObj != null) {
            PasswordHolder passwordHolder = (PasswordHolder)passwordObj;
            jdbcProps.put("password", passwordHolder.getPassword());
        }
        return jdbcProps;
    }

    public static void initializeDataSource(CommonDataSource commonDataSource, Map<String, Object> componentProperties, final LogService logService) {
        Integer loginTimeout = (Integer)componentProperties.get("loginTimeout");
        if (loginTimeout != null) {
            try {
                commonDataSource.setLoginTimeout(loginTimeout);
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not set timeout on data source" + commonDataSource.toString(), e);
            }
        }
        try {
            commonDataSource.setLogWriter(new PrintWriter(new Writer(){
                ConcurrentLinkedQueue<String> messageQueue = new ConcurrentLinkedQueue();

                @Override
                public void close() throws IOException {
                }

                @Override
                public void flush() throws IOException {
                    StringBuilder sb = new StringBuilder();
                    String message = this.messageQueue.poll();
                    while (message != null) {
                        sb.append(message);
                        message = this.messageQueue.poll();
                    }
                    if (sb.length() > 0) {
                        logService.log(3, sb.toString());
                    }
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    String message = String.valueOf(cbuf, off, len);
                    this.messageQueue.add(message);
                }
            }));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error during setting logWrtier to dataSource:" + commonDataSource.toString());
        }
    }

    private static void putIfNotNull(Map<String, Object> source, Hashtable<? super String, Object> target, String key) {
        Object value = source.get(key);
        if (value != null && !"".equals(value.toString().trim())) {
            target.put(key, value);
        }
    }

    private static void putVisibleProperties(Map<String, Object> source, Hashtable<? super String, Object> target) {
        String[] customProperties;
        DSFUtil.putIfNotNull(source, target, "url");
        DSFUtil.putIfNotNull(source, target, "networkProtocol");
        DSFUtil.putIfNotNull(source, target, "serverName");
        DSFUtil.putIfNotNull(source, target, "portNumber");
        DSFUtil.putIfNotNull(source, target, "databaseName");
        DSFUtil.putIfNotNull(source, target, "user");
        DSFUtil.putIfNotNull(source, target, "dataSourceName");
        DSFUtil.putIfNotNull(source, target, "roleName");
        DSFUtil.putIfNotNull(source, target, "description");
        DSFUtil.putIfNotNull(source, target, "maxIdleTime");
        DSFUtil.putIfNotNull(source, target, "maxStatements");
        DSFUtil.putIfNotNull(source, target, "propertyCycle");
        DSFUtil.putIfNotNull(source, target, "initialPoolSize");
        DSFUtil.putIfNotNull(source, target, "minPoolSize");
        DSFUtil.putIfNotNull(source, target, "maxPoolSize");
        Object customPropertiesObj = source.get("customProperties");
        if (customPropertiesObj == null) {
            return;
        }
        if (!(customPropertiesObj instanceof String[])) {
            throw new IllegalArgumentException("customProperties property must have the type String[]: " + customPropertiesObj.getClass().getName());
        }
        for (String customProperty : customProperties = (String[])customPropertiesObj) {
            if (customProperty == null || "".equals(customProperty.trim())) continue;
            int indexOfEquals = customProperty.indexOf(61);
            if (indexOfEquals < 1) {
                throw new IllegalArgumentException("Invalid syntax for custom property: " + customProperty);
            }
            if (indexOfEquals == customProperty.length() - 1) continue;
            String key = customProperty.substring(0, indexOfEquals);
            String value = customProperty.substring(indexOfEquals + 1, customProperty.length());
            target.put(key, value);
        }
    }

    private DSFUtil() {
    }
}

