/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.jdbc.dsf.ecm.internal;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XADataSource;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.jdbc.dsf.ecm.internal.AbstractDataSourceComponent;

@Component(componentId="org.everit.persistence.jdbc.dsf.ecm.XADataSource", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit XADataSource", description="Instantiates and registers a new XADataSource by using a DataSourceFactory OSGi service.")
@StringAttributes(value={@StringAttribute(attributeId="maxIdleTime", optional=true, priority=11.0f, label="Max. idle time"), @StringAttribute(attributeId="maxStatements", optional=true, priority=12.0f, label="Max. statements"), @StringAttribute(attributeId="propertyCycle", optional=true, priority=13.0f, label="Property lifecycle"), @StringAttribute(attributeId="initialPoolSize", optional=true, priority=14.0f, label="Initial pool size"), @StringAttribute(attributeId="minPoolSize", optional=true, priority=15.0f, label="Min. pool size"), @StringAttribute(attributeId="maxPoolSize", optional=true, priority=16.0f, label="Max. pool size")})
@ManualServices(value={@ManualService(value={XADataSource.class})})
@ExtendComponent
public class XADataSourceComponent
extends AbstractDataSourceComponent<XADataSource> {
    public static final int P11_JDBC_MAX_IDLE_TIME = 11;
    public static final int P12_JDBC_MAX_STATEMENTS = 12;
    public static final int P13_JDBC_PROPERTY_CYCLE = 13;
    public static final int P14_JDBC_INITIAL_POOL_SIZE = 14;
    public static final int P15_JDBC_MIN_POOL_SIZE = 15;
    public static final int P16_JDBC_MAX_POOL_SIZE = 16;

    @Override
    protected XADataSource createServiceObject(Properties jdbcProps) throws SQLException {
        return this.dataSourceFactory.createXADataSource(jdbcProps);
    }

    @Override
    protected Class<XADataSource> getServiceType() {
        return XADataSource.class;
    }
}

