/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.jtds.ecm.internal;

import java.util.Hashtable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import net.sourceforge.jtds.jdbcx.JtdsDataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.attribute.BooleanAttribute;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttribute;
import org.everit.osgi.ecm.annotation.attribute.IntegerAttributeOption;
import org.everit.osgi.ecm.annotation.attribute.LongAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributeOption;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.persistence.jtds.ecm.JtdsDataSourceComponent", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit jTDS DataSource", description="Configurable component that instantiates JtdsDataSource and registers it as an OSGi service based on DataSource, XADataSource and PoolingDataSource interfaces.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", optional=true, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualServices(value={@ManualService(value={DataSource.class, XADataSource.class, ConnectionPoolDataSource.class, JtdsDataSource.class})})
@ExtendComponent
public class JtdsDataSourceComponent {
    private String appName;
    private boolean autoCommit;
    private Integer batchSize;
    private String bindAddress;
    private String bufferDir;
    private int bufferMaxMemory;
    private int bufferMinPackets;
    private boolean cacheMetaData;
    private String charset;
    private String databaseName;
    private String description;
    private String domain;
    private String instance;
    private String language;
    private boolean lastUpdateCount;
    private long lobBuffer;
    private String logFile;
    private Integer loginTimeout;
    private String macAddress;
    private int maxStatements;
    private boolean namedPipe;
    private Integer packetSize;
    private String password;
    private Integer portNumber;
    private Integer prepareSql;
    private String processId;
    private String progName;
    private boolean sendStringParametersAsUnicode;
    private String serverName;
    private int serverType;
    private ServiceRegistration<?> serviceRegistration;
    private boolean socketKeepAlive;
    private int socketTimeout;
    private String ssl;
    private boolean tcpNoDelay;
    private String tds;
    private boolean useCursors;
    private boolean useJCIFS;
    private boolean useKerberos;
    private boolean useLOBs;
    private boolean useNTLMv2;
    private String user;
    private String wsid;
    private boolean xaEmulation;

    @Activate
    public void activate(ComponentContext<JtdsDataSourceComponent> componentContext) {
        JtdsDataSource jtdsDataSource = new JtdsDataSource();
        this.updatePropertiesAToD(jtdsDataSource);
        this.updatePropertiesIToN(jtdsDataSource);
        this.updatePropertiesPToX(jtdsDataSource);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(new String[]{DataSource.class.getName(), XADataSource.class.getName(), ConnectionPoolDataSource.class.getName(), JtdsDataSource.class.getName()}, (Object)jtdsDataSource, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @StringAttribute(attributeId="appName", defaultValue={"jTDS"}, priority=9.0f, label="Application name", description="No practical use, it's displayed by Enterprise Manager or Profiler associated with the connection.")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @BooleanAttribute(attributeId="autoCommit", defaultValue={true}, priority=7.0f, label="Auto commit", description="The jTDS driver enables auto commit by default. Use this option to disable auto commit for newly created connections.")
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @IntegerAttribute(attributeId="batchSize", optional=true, priority=10.0f, label="Batch size", description="Controls how many statements are sent to the server in a batch. The actual batch is broken up into pieces this large that are sent separately. The reason for this is to avoid Sybase \"hangs\" caused by running out of space with very large batches. The problem doesn't seem to occur with SQL Server, hence the default limit of 0 (unlimited) in this case. (default - 0 for SQL Server; 1000 for Sybase)")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @StringAttribute(attributeId="bindAddress", optional=true, priority=11.0f, label="Bind address", description="Specifies the local IP address to bind to for outgoing TCP/IP connections to the database. Useful for multi-homed systems (those with more than one external IP address) where the default IP address picked by Java will not connect to the database. Currently has no effect when using named pipes to connect to a database (see namedPipe). (default - determined by the Java implementation; requires Java 1.4 or later)")
    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @StringAttribute(attributeId="bufferDir", optional=true, priority=12.0f, label="Buffer dir", description="Controls the destination where data is buffered to disk. See also bufferMaxMemory and bufferMinPackets. (default - System.getProperty(\"java.io.tmpdir\"))")
    public void setBufferDir(String bufferDir) {
        this.bufferDir = bufferDir;
    }

    @IntegerAttribute(attributeId="bufferMaxMemory", defaultValue={1024}, priority=13.0f, label="Buffer max memory", description="Controls the global buffer memory limit for all connections (in kilobytes). When the amount of buffered server response packets reaches this limit additional packets are buffered to disk; there is however one exception: each Statement gets to buffer at least <bufferMinPackets> to memory before this limit is enforced. This means that this limit can and will usually be exceeded. Server responses are buffered to disk only when a request is made on a Statement while another Statement belonging to the same Connection still hasn't processed all its results. These situations can be avoided in most cases by setting the useCursors property, but this will also affect performance. See also bufferMinPackets.")
    public void setBufferMaxMemory(int bufferMaxMemory) {
        this.bufferMaxMemory = bufferMaxMemory;
    }

    @IntegerAttribute(attributeId="bufferMinPackets", defaultValue={8}, priority=14.0f, label="Buffer min packets", description="Controls the minimum number of packets per statement to buffer to memory. Each Statement will buffer at least this many packets before being forced to use a temporary file if the <bufferMaxMemory> is reached, to ensure good performance even when one Statement caches a very large amount of data. Server responses are buffered to disk only when a request is made on a Statement while another Statement belonging to the same Connection still hasn't processed all its results. These situations can be avoided in most cases by setting the useCursors property, but this will also affect performance. See also bufferMaxMemory.")
    public void setBufferMinPackets(int bufferMinPackets) {
        this.bufferMinPackets = bufferMinPackets;
    }

    @BooleanAttribute(attributeId="cacheMetaData", defaultValue={false}, priority=16.0f, label="Cache metadata", description="When used with prepareSQL=3, setting this property to true will cause the driver to cache column meta data for SELECT statements. Caching the meta data will reduce the processing overhead when reusing statements that return small result sets that have many columns but may lead to unexpected errors if the database schema changes after the statement has been prepared. Use with care. Only applicable to SQL Server (there is no prepareSQL=3 mode for Sybase).")
    public void setCacheMetaData(boolean cacheMetaData) {
        this.cacheMetaData = cacheMetaData;
    }

    @StringAttribute(attributeId="charset", optional=true, priority=15.0f, label="Charset", description="Very important setting, determines the byte value to character mapping for CHAR/VARCHAR/TEXT values. Applies for characters from the extended set (codes 128-255). For NCHAR/NVARCHAR/NTEXT values doesn't have any effect since these are stored using Unicode. (default - the character set the server was installed with)")
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @StringAttribute(attributeId="databaseName", optional=true, priority=6.0f, label="Database name", description="JDBC term: catalog (default - the user's default database).")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @StringAttribute(attributeId="description", optional=true, priority=17.0f, label="Description")
    public void setDescription(String description) {
        this.description = description;
    }

    @StringAttribute(attributeId="domain", optional=true, priority=18.0f, label="Domain", description="Specifies the Windows domain to authenticate in. If present and the user name and password are provided, jTDS uses Windows (NTLM) authentication instead of the usual SQL Server authentication (i.e. the user and password provided are the domain user and password). This allows non-Windows clients to log in to servers which are only configured to accept Windoes authentication. If the domain parameter is present but no user name and password are provided, jTDS uses its native Single-Sign-On library and logs in with the logged Windows user's credentials (for this to work one would obviously need to be on Windows, logged into a domain, and also have the SSO library installed -- consult README.SSO in the distribution on how to do this).")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @StringAttribute(attributeId="instance", optional=true, priority=19.0f, label="Instance", description="Named instance to connect to. SQL Server can run multiple so-called \"named instances\" (i.e. different server instances, running on different TCP ports) on the same machine. When using Microsoft tools, selecting one of these instances is made by using \"<host_name>\\<instance_name>\" instead of the usual \"<host_name>\". With jTDS you will have to split the two and use the instance name as a property.")
    public void setInstance(String instance) {
        this.instance = instance;
    }

    @StringAttribute(attributeId="language", optional=true, priority=20.0f, label="Language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @BooleanAttribute(attributeId="lastUpdateCount", defaultValue={true}, priority=21.0f, label="Last update count", description="If true only the last update count will be returned by executeUpdate(). This is useful in case you are updating or inserting into tables that have triggers (such as replicated tables); there's no way to make the difference between an update count returned by a trigger and the actual update count but the actual update count is always the last as the triggers execute first. If false all update counts are returned; use getMoreResults() to loop through them.")
    public void setLastUpdateCount(boolean lastUpdateCount) {
        this.lastUpdateCount = lastUpdateCount;
    }

    @LongAttribute(attributeId="lobBuffer", defaultValue={32768L}, priority=22.0f, label="Lob buffer", description="The amount of LOB data to buffer in memory before caching to disk. The value is in bytes for Blob data and chars for Clob data.")
    public void setLobBuffer(long lobBuffer) {
        this.lobBuffer = lobBuffer;
    }

    @StringAttribute(attributeId="logFile", optional=true, priority=23.0f, label="Log file")
    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    @IntegerAttribute(attributeId="loginTimeout", optional=true, priority=24.0f, label="Login timeout", description="The amount of time to wait (in seconds) for a successful connection before timing out. If a TCP/IP connection is used to connect to the database and Java 1.4 or newer is being used, the loginTimeout parameter is used to set the initial connection timeout when initially opening a new socket. A value of zero (the default) causes the connection to wait indefinitely, e.g.,until a connection is established or an error occurs. See also socketTimeout. If a named pipe connection is used (namedPipe is true) and loginTimeout is greater than zero, the value of loginTimeout is used for the length of the retry period when \"All pipe instances are busy\" error messages are received while attempting to connect to the server. If loginTimeout is zero (the default), a value of 20 seconds is used for the named pipe retry period. (default - 0 for TCP/IP connections or 20 for named pipe connections)")
    public void setLoginTimeout(Integer loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    @StringAttribute(attributeId="macAddress", defaultValue={"000000000000"}, priority=25.0f, label="MAC address", description="Network interface card MAC address. It's displayed by Enterprise Manager or Profiler associated with the connection and is needed to resolve some issues regarding the number of clients allowed by the SQL Server license. The MAC address cannot be determined automatically from Java (i.e. without using native code) so you'll have to specify it yourself if you need it.")
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @IntegerAttribute(attributeId="maxStatements", defaultValue={500}, priority=26.0f, label="Max statements", description="The number of statement prepares each connection should cache. A value of 0 will disable statement caching. A value of Integer.MAX_VALUE (2147483647) will enable fast caching (uses less memory and has no overhead associated with removing statements); the cache will never release any cached statements, so although experience has shown that this is usually not a problem with most applications, use with care.")
    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    @BooleanAttribute(attributeId="namedPipe", defaultValue={false}, priority=27.0f, label="Named pipe", description="When set to true, named pipe communication is used to connect to the database instead of TCP/IP sockets. When the os.name system property starts with \"windows\" (case-insensitive), named pipes (both local and remote) are accessed through the Windows filesystem by opening a RandomAccessFile to the path. When the SQL Server and the client are on the same machine, a named pipe will usually have better performance than TCP/IP sockets since the network layer is eliminated. Otherwise the JCIFS library is used. JCIFS provides a pure Java named pipe implementation and uses NTLM authentication, so the domain parameter is required. This feature supports the instance parameter (which changes the named pipe URL), but it does not currently support the named pipe at a location other than /sql/query on the server. The port parameter is ignored if set.")
    public void setNamedPipe(boolean namedPipe) {
        this.namedPipe = namedPipe;
    }

    @IntegerAttribute(attributeId="packetSize", optional=true, priority=28.0f, label="Packet size", description="The network packet size (a multiple of 512). (default - 4096 for TDS 7.0/8.0; 512 for TDS 4.2/5.0)")
    public void setPacketSize(Integer packetSize) {
        this.packetSize = packetSize;
    }

    @StringAttribute(attributeId="password", priority=5.0f, label="Password", description="Password to use for login. When using getConnection(String url, String user, String password) it's not required to set this property as it is passed as parameter, but you will have to set it when using getConnection(String url, Properties info) or JtdsDataSource.")
    public void setPassword(String password) {
        this.password = password;
    }

    @IntegerAttribute(attributeId="port", optional=true, priority=3.0f, label="Port", description="The port the database server is listening to (default - 1433 for SQL Server and 7100 for Sybase)")
    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    @IntegerAttribute(attributeId="prepareSQL", optional=true, priority=29.0f, label="Prepare SQL", description="This parameter specifies the mechanism used for Prepared Statements. 0 - SQL is sent to the server each time without any preparation, literals are inserted in the SQL (slower). 1 - Temporary stored procedures are created for each unique SQL statement and parameter combination (faster). 2 - sp_executesql is used (fast). 3 - sp_prepare and sp_cursorprepare are used in conjunction with sp_execute and sp_cursorexecute (faster, SQL Server only). (default - 3 for SQL Server, 1 for Sybase)")
    public void setPrepareSql(Integer prepareSql) {
        this.prepareSql = prepareSql;
    }

    @StringAttribute(attributeId="processId", defaultValue={"123"}, label="Process id", description="The client process ID associated with the connection. Must be an integer value or the string \"compute\" to let jTDS choose a process ID.")
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @StringAttribute(attributeId="progName", defaultValue={"jTDS"}, priority=30.0f, label="Program name", description="Client library name. No practical use, it's displayed by Enterprise Manager or Profiler associated with the connection.")
    public void setProgName(String progName) {
        this.progName = progName;
    }

    @BooleanAttribute(attributeId="sendStringParametersAsUnicode", defaultValue={true}, priority=31.0f, label="Send string parameter as unicode", description="Determines whether string parameters are sent to the SQL Server database in Unicode or in the default character encoding of the database. This seriously affects SQL Server 2000 performance since it does not automatically cast the types (as 7.0 does), meaning that if a index column is Unicode and the string is submitted using the default character encoding (or the other way around) SQLServer will perform an index scan instead of an index seek. For Sybase, determines if strings that cannot be encoded in the server's charset are sent as unicode strings. There is a performance hit for the encoding logic so set this option to false if unitext or univarchar data types are not in use or if charset is utf-8.")
    public void setSendStringParametersAsUnicode(boolean sendStringParametersAsUnicode) {
        this.sendStringParametersAsUnicode = sendStringParametersAsUnicode;
    }

    @StringAttribute(attributeId="serverName", priority=2.0f, label="Server name", description="Name or IP of the database server")
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @IntegerAttribute(attributeId="serverType", priority=1.0f, label="Server type", description="Type of the database server. 1 - sqlserver, 2 - sybase", options={@IntegerAttributeOption(value=1, label="SQLServer"), @IntegerAttributeOption(value=2, label="Sybase")}, defaultValue={1})
    public void setServerType(int serverType) {
        this.serverType = serverType;
    }

    @BooleanAttribute(attributeId="socketKeepAlive", defaultValue={false}, priority=32.0f, label="Socket keepalive", description="True to enable TCP/IP keep-alive messages.")
    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    @IntegerAttribute(attributeId="socketTimeout", defaultValue={0}, priority=33.0f, label="Socket timeout", description="The amount of time to wait (in seconds) for a server response before timing out. Use with care! If a non zero value is supplied this must be greater than the maximum time that the server will take to answer any query. Once the timeout value is exceeded the network or named pipe connection will be closed. This parameter may be useful for detecting dead network connections in a pooled environment. See also loginTimeout. If using named pipes via JCIFS the timeout cannot be disabled completely. A timeout of about 25 days (2^31 ms) is applied instead.")
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @StringAttribute(attributeId="ssl", priority=8.0f, label="SSL", description="Specifies if and how to use SSL for secure communication. off - SSL is not request or used; this is the default. request - SSL is requested; if the server does not support it then a plain connection is used. require - SSL is requested; if the server does not support it then an exception is thrown. authenticate - Same as require except the server's certificate must be signed by a trusted CA.", options={@StringAttributeOption(label="Off", value="off"), @StringAttributeOption(label="Request", value="request"), @StringAttributeOption(label="Require", value="require"), @StringAttributeOption(label="Authenticate", value="authenticate")}, defaultValue={"off"})
    public void setSsl(String ssl) {
        this.ssl = ssl;
    }

    @BooleanAttribute(attributeId="tcpNoDelay", defaultValue={true}, priority=34.0f, label="TCP no delay", description="true to enable TCP_NODELAY on the socket; false to disable it.")
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @StringAttribute(attributeId="tds", optional=true, priority=35.0f, label="TDS", description="The version of TDS to be used. TDS (Tabular Data Stream) is the protocol used by Microsoft SQL Server and Sybase to communicate with database clients. jTDS can use TDS 4.2, 5.0, 7.0 and 8.0. Version 4.2 is used by SQL Server 6.5 and Sybase 10. Version 5.0 is used with Sybase 11 onwards. Version 7.0 is used by SQL Server 7.0; this protocol also works with SQL Server 2000. Version 8.0 is used by SQL Server 2000 and SQL Server 2005. Newer database server versions usually understand older protocol versions. This means that SQL Server 7.0 can be used with TDS 4.2, but the limitations of the protocol apply regardless of the server version (e.g. when using TDS 4.2 VARCHARs are limited to 255 characters). As a conclusion, you must set this property to \"4.2\" when connecting to SQL Server 6.5 or Sybase. You should not set this value to \"7.0\" or \"8.0\") when connecting to any version of Sybase as these are SQL Server specific protocols. Further, you should not set this value to \"5.0\") when connecting to any version of SQL Server as this is a Sybase specific protocol. Currently jTDS automatically falls back from 8.0 to 7.0 (if used with SQL Server 7.0) and from 5.0 to 4.2 (with Sybase 10) so specifying the value for this parameter is only necessary for SQL Server 6.5. (default - \"8.0\" for SQL Server; \"5.0\" for Sybase)")
    public void setTds(String tds) {
        this.tds = tds;
    }

    @BooleanAttribute(attributeId="useCursors", defaultValue={false}, priority=36.0f, label="User cursors", description="Instructs jTDS to use server side cursors instead of direct selects (AKA firehose cursors) for forward-only read-only result sets (with other types of result sets server- or client-side cursors are always used). With firehose cursors the SELECT query is sent and the server responds with all the resulting rows. This is the fastest approach but it means that the driver has to cache all results if another request needs to be made before all rows have been processed. So when using multiple Statements per Connection it is preferable to have server-side cursors instead; these will allow the driver to request only a limited number of rows at a time (controllable through the fetchSize property of a Statement). This means extra request-response cycles, but less caching by the driver. With SQL Server a so called fast forward-only cursor will be created when this property is set to true. With Sybase a usual forward-only read-only cursor is created.")
    public void setUseCursors(boolean useCursors) {
        this.useCursors = useCursors;
    }

    @BooleanAttribute(attributeId="useJCIFS", defaultValue={false}, priority=37.0f, label="Use JCIFS", description="Controls whether the jCIFS library will be used instead of the local file system with named pipe connections on the Windows operating system. (The jCIFS library will always be used with named pipes when the operating system is not Windows.) Useful when connecting via named pipes to a server that is located in a different domain than the client. See also namedPipe.")
    public void setUseJCIFS(boolean useJCIFS) {
        this.useJCIFS = useJCIFS;
    }

    @BooleanAttribute(attributeId="useKerberos", defaultValue={false}, priority=38.0f, label="Use kerberos")
    public void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    @BooleanAttribute(attributeId="useLOBs", defaultValue={true}, priority=39.0f, label="Use LOBs", description="Controls whether large types (IMAGE and TEXT/NTEXT) should be mapped by default (when using getObject()) to LOBs or Java types (String and byte[]). The default JDBC type constant returned is also controlled by this property: Types.BLOB for IMAGE and Types.CLOB for TEXT/NTEXT when true, Types.LONGVARBINARY for IMAGE and Types.LONGVARCHAR for TEXT/NTEXT when false. This is useful when printing out directly the values returned by getObject() (e.g. when using JSTL or other frameworks), as Blob and Clob don't implement toString() (both because it's not required and because it can easily lead to OutOfMemoryErrors in unexpected situations, such as when logging data). The default setting of true has the advantage that the amount of data that is cached in memory for a large object can be controlled via the lobBuffer property; a setting of false will still use the Blob and Clob implementations internally but the values will be materialized to memory when getObject() is called, possibly leading to memory issues.")
    public void setUseLOBs(boolean useLOBs) {
        this.useLOBs = useLOBs;
    }

    @BooleanAttribute(attributeId="useNTLMv2", defaultValue={false}, priority=40.0f, label="Use NTLMv2", description="Set to true to send LMv2/NTLMv2 responses when using Windows authentication.")
    public void setUseNTLMv2(boolean useNTLMv2) {
        this.useNTLMv2 = useNTLMv2;
    }

    @StringAttribute(attributeId="user", priority=4.0f, label="User", description="User name to use for login. When using getConnection(String url, String user, String password) it's not required to set this property as it is passed as parameter, but you will have to set it when using getConnection(String url, Properties info) or JtdsDataSource.")
    public void setUser(String user) {
        this.user = user;
    }

    @StringAttribute(attributeId="wsid", optional=true, priority=41.0f, label="WSID", description="Workstation ID. No practical use, it's displayed by Enterprise Manager or Profiler associated with the connection. (default - the client host name)")
    public void setWsid(String wsid) {
        this.wsid = wsid;
    }

    @BooleanAttribute(attributeId="xaEmulation", defaultValue={true}, label="XA emulation", description="When set to true, emulate XA distributed transaction support, when set to false use experimental true distributed transaction support. True distributed transaction support is only available for SQL Server 2000 and requires the installation of an external stored procedure in the target server (see the README.XA file in the distribution for details).")
    public void setXaEmulation(boolean xaEmulation) {
        this.xaEmulation = xaEmulation;
    }

    private void updatePropertiesAToD(JtdsDataSource jtdsDataSource) {
        jtdsDataSource.setAppName(this.appName);
        jtdsDataSource.setAutoCommit(this.autoCommit);
        if (this.batchSize != null) {
            jtdsDataSource.setBatchSize(this.batchSize.intValue());
        }
        if (this.bindAddress != null) {
            jtdsDataSource.setBindAddress(this.bindAddress);
        }
        if (this.bufferDir != null) {
            jtdsDataSource.setBufferDir(this.bufferDir);
        }
        jtdsDataSource.setBufferMaxMemory(this.bufferMaxMemory);
        jtdsDataSource.setBufferMinPackets(this.bufferMinPackets);
        jtdsDataSource.setCacheMetaData(this.cacheMetaData);
        if (this.charset != null) {
            jtdsDataSource.setCharset(this.charset);
        }
        if (this.databaseName != null) {
            jtdsDataSource.setDatabaseName(this.databaseName);
        }
        if (this.description != null) {
            jtdsDataSource.setDescription(this.description);
        }
        if (this.domain != null) {
            jtdsDataSource.setDomain(this.domain);
        }
    }

    private void updatePropertiesIToN(JtdsDataSource jtdsDataSource) {
        if (this.instance != null) {
            jtdsDataSource.setInstance(this.instance);
        }
        if (this.language != null) {
            jtdsDataSource.setLanguage(this.language);
        }
        jtdsDataSource.setLastUpdateCount(this.lastUpdateCount);
        jtdsDataSource.setLobBuffer(this.lobBuffer);
        if (this.logFile != null) {
            jtdsDataSource.setLogFile(this.logFile);
        }
        if (this.loginTimeout != null) {
            jtdsDataSource.setLoginTimeout(this.loginTimeout.intValue());
        }
        jtdsDataSource.setMacAddress(this.macAddress);
        jtdsDataSource.setMaxStatements(this.maxStatements);
        jtdsDataSource.setNamedPipe(this.namedPipe);
    }

    private void updatePropertiesPToX(JtdsDataSource jtdsDataSource) {
        if (this.packetSize != null) {
            jtdsDataSource.setPacketSize(this.packetSize.intValue());
        }
        jtdsDataSource.setPassword(this.password);
        if (this.portNumber != null) {
            jtdsDataSource.setPortNumber(this.portNumber.intValue());
        }
        if (this.prepareSql != null) {
            jtdsDataSource.setPrepareSql(this.prepareSql.intValue());
        }
        jtdsDataSource.setProcessId(this.processId);
        jtdsDataSource.setProgName(this.progName);
        jtdsDataSource.setSendStringParametersAsUnicode(this.sendStringParametersAsUnicode);
        jtdsDataSource.setServerName(this.serverName);
        jtdsDataSource.setServerType(this.serverType);
        jtdsDataSource.setSocketKeepAlive(this.socketKeepAlive);
        jtdsDataSource.setSocketTimeout(this.socketTimeout);
        jtdsDataSource.setSsl(this.ssl);
        jtdsDataSource.setTcpNoDelay(this.tcpNoDelay);
        if (this.tds != null) {
            jtdsDataSource.setTds(this.tds);
        }
        jtdsDataSource.setUseCursors(this.useCursors);
        jtdsDataSource.setUseJCIFS(this.useJCIFS);
        jtdsDataSource.setUseKerberos(this.useKerberos);
        jtdsDataSource.setUseLOBs(this.useLOBs);
        jtdsDataSource.setUseNTLMV2(this.useNTLMv2);
        jtdsDataSource.setUser(this.user);
        if (this.wsid != null) {
            jtdsDataSource.setWsid(this.wsid);
        }
        jtdsDataSource.setXaEmulation(this.xaEmulation);
    }
}

