/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.mysema.codegen.Evaluator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public final class MethodEvaluator<T>
implements Evaluator<T> {
    private final Method method;
    private final Class<? extends T> projectionType;
    private final Object[] args;

    MethodEvaluator(Method method, Map<String, Object> constants, Class<? extends T> projectionType) {
        this.method = method;
        this.projectionType = projectionType;
        this.args = new Object[method.getParameterTypes().length];
        int i = this.args.length - constants.size();
        for (Object value : constants.values()) {
            this.args[i++] = value;
        }
    }

    @Override
    public T evaluate(Object ... args) {
        try {
            System.arraycopy(args, 0, this.args, 0, args.length);
            return (T)this.method.invoke(null, this.args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class<? extends T> getType() {
        return this.projectionType;
    }
}

