/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.AbstractWkbEncoder;
import org.geolatte.geom.codec.WkbVisitor;

class PostgisWkbEncoder
extends AbstractWkbEncoder {
    PostgisWkbEncoder() {
    }

    @Override
    protected int sizeEmptyGeometry(Geometry geometry) {
        return 4;
    }

    @Override
    protected WkbVisitor newWkbVisitor(ByteBuffer output) {
        return new PostgisWkbVisitor(output);
    }

    private static class PostgisWkbVisitor
    extends WkbVisitor {
        private boolean hasWrittenSrid = false;

        PostgisWkbVisitor(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        protected void writeTypeCodeAndSrid(Geometry geometry, DimensionalFlag dimension, ByteBuffer output) {
            boolean hasSrid;
            int typeCode = this.getGeometryType(geometry);
            boolean bl = hasSrid = geometry.getSRID() > 0;
            if (hasSrid && !this.hasWrittenSrid) {
                typeCode |= 0x20000000;
            }
            if (dimension.isMeasured()) {
                typeCode |= 0x40000000;
            }
            if (dimension.is3D()) {
                typeCode |= Integer.MIN_VALUE;
            }
            output.putUInt(typeCode);
            if (hasSrid && !this.hasWrittenSrid) {
                output.putInt(geometry.getSRID());
                this.hasWrittenSrid = true;
            }
        }
    }
}

