/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WkbGeometryType;

class WkbVisitor
implements GeometryVisitor {
    private final ByteBuffer output;

    WkbVisitor(ByteBuffer byteBuffer) {
        this.output = byteBuffer;
    }

    @Override
    public void visit(Point geom) {
        this.writeByteOrder(this.output);
        DimensionalFlag dimension = DimensionalFlag.valueOf(geom.is3D(), geom.isMeasured());
        this.writeTypeCodeAndSrid(geom, dimension, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.writePoints(geom.getPoints(), geom.getCoordinateDimension(), this.output);
        }
    }

    @Override
    public void visit(LineString geom) {
        this.writeByteOrder(this.output);
        DimensionalFlag dimension = DimensionalFlag.valueOf(geom.is3D(), geom.isMeasured());
        this.writeTypeCodeAndSrid(geom, dimension, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.output.putUInt(geom.getNumPoints());
            this.writePoints(geom.getPoints(), geom.getCoordinateDimension(), this.output);
        }
    }

    @Override
    public void visit(Polygon geom) {
        this.writeByteOrder(this.output);
        DimensionalFlag dimension = DimensionalFlag.valueOf(geom.is3D(), geom.isMeasured());
        this.writeTypeCodeAndSrid(geom, dimension, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.writeNumRings(geom, this.output);
            for (LinearRing ring : geom) {
                this.writeRing(ring);
            }
        }
    }

    @Override
    public void visit(PolyHedralSurface geom) {
        this.writeByteOrder(this.output);
        DimensionalFlag dimension = DimensionalFlag.valueOf(geom.is3D(), geom.isMeasured());
        this.writeTypeCodeAndSrid(geom, dimension, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.output.putUInt(geom.getNumPatches());
            for (Polygon pg : geom) {
                pg.accept(this);
            }
        }
    }

    @Override
    public void visit(GeometryCollection geom) {
        this.writeByteOrder(this.output);
        DimensionalFlag dimension = DimensionalFlag.valueOf(geom.is3D(), geom.isMeasured());
        this.writeTypeCodeAndSrid(geom, dimension, this.output);
        this.output.putUInt(geom.getNumGeometries());
    }

    @Override
    public void visit(LinearRing geom) {
        this.writeByteOrder(this.output);
        DimensionalFlag dimension = DimensionalFlag.valueOf(geom.is3D(), geom.isMeasured());
        this.writeTypeCodeAndSrid(geom, dimension, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.writeRing(geom);
        }
    }

    protected void writeRing(LinearRing geom) {
        this.output.putUInt(geom.getNumPoints());
        this.writePoints(geom.getPoints(), geom.getCoordinateDimension(), this.output);
    }

    protected void writeNumRings(Polygon geom, ByteBuffer byteBuffer) {
        byteBuffer.putUInt(geom.isEmpty() ? 0L : (long)(geom.getNumInteriorRing() + 1));
    }

    protected void writePoint(double[] coordinates, ByteBuffer output) {
        for (double coordinate : coordinates) {
            output.putDouble(coordinate);
        }
    }

    protected void writePoints(PointSequence points, int coordinateDimension, ByteBuffer output) {
        double[] coordinates = new double[coordinateDimension];
        for (int i = 0; i < points.size(); ++i) {
            points.getCoordinates(coordinates, i);
            this.writePoint(coordinates, output);
        }
    }

    protected void writeByteOrder(ByteBuffer output) {
        output.put(output.getByteOrder().byteValue());
    }

    protected void writeTypeCodeAndSrid(Geometry geometry, DimensionalFlag dimension, ByteBuffer output) {
        int typeCode = this.getGeometryType(geometry);
        output.putUInt(typeCode);
    }

    protected int getGeometryType(Geometry geometry) {
        if (geometry.isEmpty()) {
            return WkbGeometryType.GEOMETRY_COLLECTION.getTypeCode();
        }
        WkbGeometryType type = WkbGeometryType.forClass(geometry.getClass());
        if (type == null) {
            throw new UnsupportedConversionException(String.format("Can't convert geometries of type %s", geometry.getClass().getCanonicalName()));
        }
        return type.getTypeCode();
    }
}

