/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.codec.AbstractWktTokenizer;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktDimensionMarkerToken;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktPointSequenceToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;
import org.geolatte.geom.crs.CrsId;

class WktTokenizer
extends AbstractWktTokenizer {
    private boolean isMeasured = false;
    private final CrsId crsId;

    protected WktTokenizer(CharSequence wkt, WktVariant variant, CrsId crsId) {
        super(wkt, variant);
        if (wkt == null || variant == null) {
            throw new IllegalArgumentException("Input WKT and variant must not be null");
        }
        this.crsId = crsId == null ? CrsId.UNDEFINED : crsId;
    }

    @Override
    WktToken numericToken() {
        DimensionalFlag dimensionalFlag = this.countDimension();
        int numPoints = this.countPoints();
        double[] coords = new double[dimensionalFlag.getCoordinateDimension()];
        PointSequenceBuilder psBuilder = PointSequenceBuilders.fixedSized(numPoints, dimensionalFlag, this.crsId);
        for (int i = 0; i < numPoints; ++i) {
            this.readPoint(coords);
            psBuilder.add(coords);
            this.skipPointDelimiter();
        }
        return new WktPointSequenceToken(psBuilder.toPointSequence());
    }

    private void readPoint(double[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.fastReadNumber();
        }
    }

    protected double fastReadNumber() {
        this.skipWhitespace();
        char c = this.wkt.charAt(this.currentPos);
        double sign = 1.0;
        if (c == '-') {
            sign = -1.0;
            c = this.wkt.charAt(++this.currentPos);
        }
        double d = 0.0;
        while (Character.isDigit(c)) {
            d = 10.0 * d + (double)(c - 48);
            c = this.wkt.charAt(++this.currentPos);
        }
        if (c == '.') {
            c = this.wkt.charAt(++this.currentPos);
            double divisor = 10.0;
            while (Character.isDigit(c)) {
                double f = c - 48;
                d += f / divisor;
                divisor *= 10.0;
                c = this.wkt.charAt(++this.currentPos);
            }
        }
        double exp = 0.0;
        double expSign = 1.0;
        if (c == 'e' || c == 'E') {
            if ((c = this.wkt.charAt(++this.currentPos)) == '-') {
                expSign = -1.0;
                c = this.wkt.charAt(++this.currentPos);
            }
            while (Character.isDigit(c)) {
                exp = 10.0 * exp + (double)(c - 48);
                c = this.wkt.charAt(++this.currentPos);
            }
        }
        return sign * d * Math.pow(10.0, expSign * exp);
    }

    private int countPoints() {
        int pos = this.currentPos + 1;
        char c = this.wkt.charAt(pos);
        int num = 1;
        while (c != ')') {
            if (c == ',') {
                ++num;
            }
            c = this.wkt.charAt(++pos);
        }
        return num;
    }

    private DimensionalFlag countDimension() {
        int pos = this.currentPos;
        int num = 1;
        boolean inNumber = true;
        char c = this.wkt.charAt(pos);
        while (c != ',' && c != this.variant.getCloseListChar()) {
            if (!Character.isDigit(c) && c != '.' && c != '-' && c != 'e' && c != 'E') {
                inNumber = false;
            } else if (!inNumber) {
                ++num;
                inNumber = true;
            }
            if (pos == this.wkt.length() - 1) {
                throw new WktDecodeException("");
            }
            c = this.wkt.charAt(++pos);
        }
        if (num == 4) {
            return DimensionalFlag.d3DM;
        }
        if (num == 3 && this.isMeasured) {
            return DimensionalFlag.d2DM;
        }
        if (num == 3 && !this.isMeasured) {
            return DimensionalFlag.d3D;
        }
        if (num == 2) {
            return DimensionalFlag.d2D;
        }
        throw new WktDecodeException("Point with less than 2 coordinates at position " + this.currentPos);
    }

    private void skipPointDelimiter() {
        this.skipWhitespace();
        if (this.wkt.charAt(this.currentPos) == ',') {
            ++this.currentPos;
        }
    }

    @Override
    protected WktToken matchKeyword(int currentPos, int endPos) {
        WktKeywordToken token = this.variant.matchKeyword(this.wkt, currentPos, endPos);
        if (token instanceof WktGeometryToken) {
            boolean bl = this.isMeasured = this.isMeasured || ((WktGeometryToken)token).isMeasured();
        }
        if (token instanceof WktDimensionMarkerToken) {
            this.isMeasured = this.isMeasured || ((WktDimensionMarkerToken)token).isMeasured();
        }
        return token;
    }
}

